#!/usr/bin/env perl

# $Id$


=head1 NAME

=encoding utf8

old_autobetas - найти автобеты из устаревших бранчей

=head1 DESCRIPTION

    Считать, что все бранчи, что есть в svn:mergeinfo у trunk — устаревшие
    вывести список автобет, смотрящих на такие бранчи. Опционально считать, что удалённые бранчи тоже устаревшие

    Опции:
    --long
        удалённые бранчи тоже устаревшие, проверять для автобет существование бранчей

=cut

use strict;
use warnings;
use utf8;
use open ':std' => ':utf8';
use Getopt::Long;

my $LONG = 0;

GetOptions(
    "help" => sub {system("podselect -section NAME -section DESCRIPTION $0 | pod2text >&2"); exit 0;},
    "long" => \$LONG,
) or die "can't parse options";

my $base = '/var/www';
opendir(D, $base) || die "Can't read dir $base";
my @dirs = grep {-d "$base/$_"} grep {/^beta.auto[\w\.\-]+$/} readdir(D);

my %MERGED;
for my $s (split ' ', `svn propget 'svn:mergeinfo' svn+ssh://svn.yandex.ru/direct/trunk`) {
    $s =~ s!^/branches!!;
    $s =~ s!^/!!;
    $s =~ /(.*):(?:.*[^\d])?\d*$/;
    print STDERR "strange mergeinfo: $s\n" if !$s || !$1;
    $MERGED{$1} = undef;
}

my $count = 0;
my @old_betas;
for my $dir (@dirs) {
    my $text = `LC_ALL=C svn info $base/$dir 2>&1`;
    my ($url) = $text =~ /^URL:\s+(.*)/m;
    next unless ($url && $url =~ m!/direct/!);
    my $URL = $url;
    next unless ($url =~ s!^.*/branches/!!);
    $count++;
    if (exists $MERGED{$url}) {
        push @old_betas, $dir;
        next;
    }
    if ($LONG) {
        print `LC_ALL=C svn info $URL 2>&1`;
    }
    # push @old_betas, [$url, $dir];
}

$, = "\n";

print "Total: " . (scalar @old_betas) . " out of $count", @old_betas, "";