#!/usr/bin/env perl

# $Id$

=head1 NAME

=encoding utf8

old_beta_stop - аккуратно остановить бету, не присвоив суперпользователю файлы на ней и не породив новые процессы

=head1 DESCRIPTION

    Скрипт для запуска от root.
    Новые беты поддерживают команду full-stop, старые предполагалось останавливать через beta-prerm,
    такой подход имеет побочные последствия. Этот скрипт вызывает более конкретные действия, если full-stop не поддерживается.

    Опции:
    --path=PATH
        абсолютный путь до беты, которую нужно остановить
    --debug
        написать в лог всё, что выводит direct-mk full-stop

=cut

use strict;
use warnings;
use Getopt::Long;
use POSIX qw/strftime/;

my ($PATH, $DEBUG);

if ($> != 0) {
    die "error: $0 should be run as root\n";
}

GetOptions(
    "help" => sub {system("podselect -section NAME -section DESCRIPTION $0 | pod2text >&2"); exit 0;},
    "path=s" => \$PATH,
    "debug" => \$DEBUG,
) or die "can't parse options";
die "Missing or bad path argument" unless ($PATH && -d $PATH);

my $date_suffix = strftime('%Y%m', localtime);
open Log, '>>', ('/var/log/ppcdev_stat/old_beta_stop.' . ($DEBUG ? 'debug.' : '') . $date_suffix . '.log') || exit;
print Log strftime("%Y-%m-%d %H:%M:%S", localtime) . " stopping $PATH\n";

my $owner_uid = (stat($PATH))[4];
my $sudo_user_arg;
if (!defined $owner_uid) {
    die "could not stat $PATH: $!";
} else {
    my $owner_login = getpwuid($owner_uid);
    if (!$owner_login) {
        $sudo_user_arg = '#' . $owner_uid;  # uid передаётся в sudo с префиксом #, например, sudo -u #9000
        print Log "could not get login for uid $owner_uid\n";
    } else {
        $sudo_user_arg = $owner_login;
    }
}

my $res = `cd $PATH && sudo -u '$sudo_user_arg' direct-mk full-stop 2>&1`;
print Log "Transcript:\n$res\n" if ($DEBUG);

my $long_stop = 0;
if ($res =~ /Can't exec/ || $res =~ /Compilation failed/) { # не работает, не компилируется, и т. п.
    print Log "full-stop action broke\n";
    $long_stop = 1;
}
if ($res =~ /know how to make/) { # бета старая
    print Log "full-stop or some child action is not supported\n";
    $long_stop = 1;
}
if ($long_stop) { # останавливаем всё, что можно остановить
    system ("cd $PATH && sudo -u '$sudo_user_arg' direct-mk java-stop > /dev/null 2>&1");
    system ("cd $PATH && sudo -u '$sudo_user_arg' direct-mk js-templater-stop > /dev/null 2>&1");
    system ("cd $PATH && sudo -u '$sudo_user_arg' ./apache/init.sh stop > /dev/null 2>&1");
    system ("cd $PATH && sudo -u '$sudo_user_arg' direct-mk nginx_stop > /dev/null 2>&1");
    system ("cd $PATH && sudo -u '$sudo_user_arg' direct-mk service ALL stop > /dev/null 2>&1");
    system ("cd $PATH && sudo -u '$sudo_user_arg' direct-mk docker-db-stop > /dev/null 2>&1");
}

print Log strftime("%Y-%m-%d %H:%M:%S", localtime) . " stopped\n";
close Log;
