#!/usr/bin/env perl

# $Id$

=head1 NAME

=encoding utf8

old_betas - найти давно не обновляющиеся беты

=head1 DESCRIPTION

    Найти давно не обновляющиеся беты, вывести их список

    Опции:
    --format=[du|human]
        выводить список для du или для людей (отсортированный по имени, построчный)
    --running=[apache|nginx|any|neither]
        показать те, на которых запущены apache|nginx|что-нибудь или ничего не запущено 

=cut

use strict;
use warnings;
use utf8;
use open ':std' => ':utf8';
use Getopt::Long;
use POSIX qw/strftime/;

my $SECONDS_IN_A_DAY = 60 * 60 * 24;
my $epoch_time = time();
my $FORMAT = 'du';
my $RUNNING = '';

GetOptions(
    "help" => sub {system("podselect -section NAME -section DESCRIPTION $0 | pod2text >&2"); exit 0;},
    "format=s" => \$FORMAT,
    "running=s" => \$RUNNING,
) or die "can't parse options";
my $re = "du|human";
die "Unknown format, must be $re" unless ($FORMAT =~ $re);
$re = "^(?:apache|nginx|any|neither|)\$";
die "Unknown «running» option, must be $re" unless ($RUNNING =~ $re);

my $PS;
if ($RUNNING) {
    if ($RUNNING eq 'any' || $RUNNING eq 'neither') {
        $PS = `ps aux | grep -P "sbin/apache|sbin/nginx"`;
    } elsif ($RUNNING eq 'apache') {
        $PS = `ps aux | grep sbin/apache`;
    } elsif ($RUNNING eq 'nginx') {
        $PS = `ps aux | grep sbin/nginx`;
    }
}

my $base = '/var/www';
opendir(D, $base) || die "Can't read dir $base";
my @dirs = grep {-d "$base/$_"} grep {/^[\w\.\-]+$/} readdir(D);
my @betas;

for my $dir (@dirs) {
    my $text = `LC_ALL=C svn info $base/$dir 2>&1`;
    my ($url) = $text =~ /^URL:\s+(.*)/m;
    next unless ($url && $url =~ m!/direct/!);
    my ($rev) = $text =~ /^Revision:\s+(.*)/m;
    if ($rev) {
        push @betas, [$rev, $dir];
    }
}

$, = "\n";
@betas = sort {$a->[0] <=> $b->[0]} @betas;

my %cats; # categories
my %cats_age = map {$_ => undef} (183, 92, 31, 14);

for my $cat_age (sort {$a <=> $b} keys %cats_age) {
    my $rev_date = strftime('%Y-%m-%d %H:%M', localtime($epoch_time - $SECONDS_IN_A_DAY * $cat_age));
    my $svnlog = `svn log svn+ssh://svn.yandex.ru/direct/ -r{"$rev_date"}`;
    $svnlog =~ /^r(\d+) /m;
    $cats_age{$cat_age} = $1 || 0;
}

foreach my $beta_info (@betas) {
    for my $cat_age (sort {$b <=> $a} keys %cats_age) {
        if ($cats_age{$cat_age} && $beta_info->[0] < $cats_age{$cat_age}) {
            if ($RUNNING eq 'any' || $RUNNING eq 'apache' || $RUNNING eq 'nginx') {
                last unless $PS =~ $beta_info->[1];
            } elsif ($RUNNING eq 'neither') {
                last if $PS =~ $beta_info->[1];
            }
            push @{$cats{$cat_age}}, $beta_info;
            last;
        }
    }
}

for my $cat_age (sort {$b <=> $a} keys %cats_age) {
    if ((exists $cats{$cat_age}) && @{$cats{$cat_age}}) {
        my $string;
        if ($FORMAT =~ /du/) {
            $string .= " $base/$_->[1]" for (@{$cats{$cat_age}});
        } elsif ($FORMAT =~ /human/) {
            my @paths = sort map {"$base/$_->[1]"} @{$cats{$cat_age}};
            $string = join $,, @paths;
        }
        print 'age: ' . $cat_age . ' days', 'total: ' . scalar(@{$cats{$cat_age}}), $string, '';
        # print `du -d0 $base/$dir`;
    }
}
