#!/bin/sh
PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin

ppcdev_name=$(hostname -f | cut -d. -f1)

if [ "$1" = "--zk" ]; then
    for zk_host in ppctest-zookeeper01i.sas.yp-c.yandex.net ppctest-zookeeper01f.myt.yp-c.yandex.net ppctest-zookeeper01v.vla.yp-c.yandex.net; do
        if nc -zw 1 "$zk_host" 2181; then
            zk="direct-zkcli --host $zk_host"
            break
        fi
    done
    output_cmd() {
    $zk tee "/direct/ppcdevs-state/$ppcdev_name/$1"
    }
else
    output_cmd() {
    perl -slne 'print $type, " ", $_' -- -type="$1"
    }
fi

free -m | awk 'NR==2 {total=$2} NR==3 {printf "%0.0f%%", $3/total*100.0}' | output_cmd mem_used
LC_ALL=C uptime | awk '{print $NF}' | output_cmd la_15
df /var/www | awk '$NF~/^.var.www$/ {print $5}' | output_cmd var_www_space_used
df -i /var/www | awk '$NF~/^.var.www$/ {print $5}' | output_cmd var_www_inodes_used
