#!/usr/bin/perl

use strict;
use warnings;

use open ':std' => ':utf8'; # обязательно перед use Test::More, т. к. "Test::Builder (which powers Test::More) duplicates STDOUT and STDERR"
use Test::More;

use lib::abs '../../lib';
use ProjectSpecific;

use utf8;

my %tests = (
    Direct => {
        8765 => "https://8765.beta1.direct.yandex.ru",
        9876 => "https://9876.beta2.direct.yandex.ru",
        10987 => "https://10987.beta3.direct.yandex.ru",
        11109 => "https://11109.beta4.direct.yandex.ru",
        12111 => "https://12111.beta5.direct.yandex.ru",
    },
    Directmod => {
        8765 => "https://8765.ppcmoddev1.yandex-team.ru",
        9876 => "https://9876.ppcmoddev2.yandex-team.ru",
    },
    Geocontext => {
        8765 => "http://8765.beta1.geocontext.yandex.ru",
    },
    Tabula => {
        8765 => "http://direct-dev.yandex-team.ru:8765",
    },
);

for my $project (keys %tests) {
    $ProjectSpecific::PROJECT = $project;
    for my $port (keys %{ $tests{ $project } }) {
        is(ProjectSpecific::beta_url($port), $tests{ $project }->{ $port }, "test url for port $port in project $project");
    }
}

done_testing();
