#!/usr/bin/perl

=head1 TEST

    Проверяем, что проектные настройки определены для всех проектов.

=cut

use strict;
use warnings;

use FindBin qw/$Bin/;
use List::MoreUtils qw/ any all /;
use Test::More;

use ProjectSpecific;
$ProjectSpecific::BASIC_PATH = "$Bin/../../etc/project_specific/basic_properties.yaml";
$ProjectSpecific::EXTENDED_PATH = '/etc/project_specific/non-existent-file.yaml';

# Список исключений для теста:
#
#   default_jira_conf -- отсутствие не критично, по умолчанию выставится 'prod'
#   jira_limtest_ticket_project, jira_load_testing_component -- по-видимому, имеют смысл только для Директа

my %exceptions = map { $_ => 1 } qw/ 
    default_jira_conf
    jira_load_testing_component
    jira_limtest_ticket_project
    startrek_release_component
    svn_path_for_project
/;
my %projects = map { $_ => 1 } qw/ Direct Directmod Geocontext Gtxcall Tabula/;

my $conf = ProjectSpecific::get_data();

# Пока все хэши с ключами-названиями проектов располагаются на первом уровне и тест опирается на это.
# Возможно, в будущем потребуется более сложная логика.
for my $key (keys %$conf) {
    next if exists $exceptions{$key};
    my $prop = $conf->{$key};
    
    # Здесь полагаем, что ключи типа Direct, Directmod, Geocontext не используются для обозначений чего-то, кроме названий проектов.
    # Если такое название понадобится для чего-то другого, то можно добавить название соответствующей настройки в исключения.
    next unless any { exists($prop->{$_}) } keys %projects;
    ok((all { exists($prop->{$_}) } keys %projects), "'$key' is defined for all projects");
    ok((all { exists($projects{$_}) } keys %$prop), "'$key' has only valid project names. Found: ".join(", ", keys %$prop));
}

done_testing();
