#!/usr/bin/perl

use strict;
use warnings;

use open ':std' => ':utf8'; # обязательно перед use Test::More, т. к. "Test::Builder (which powers Test::More) duplicates STDOUT and STDERR"
use Test::More;

use ProjectSpecific;

use utf8;

my $name = 'Название релиза';
my $version = '1.1234.5678-1';

for my $project (qw/Direct Directmod Geocontext Gtxcall/) {
    $ProjectSpecific::PROJECT = $project;
    my $format = ProjectSpecific::get_project_data('release_summary_format');
    my $re = ProjectSpecific::get_project_data('release_summary_regexp');

    my $summary = sprintf $format, $name, $version;
    ok($summary =~ /$re/, "summary '$summary' generated for $project matches regexp /$re/");

    my ($extracted_name, $extracted_version) = $summary =~ /$re/;
    ok($extracted_name eq $name && $extracted_version eq $version, "summary '$summary' is parsed correctly");
}

done_testing();
