# -*- coding: utf-8 -*-
# vim: set expandtab:tabstop=4:softtabstop=4:shiftwidth=4
# $Id$

# Аналог ProjectSpecific.pm для Python-кода Директа

import sys
import os
import copy
import re
import yaml
import subprocess

class ProjectSpecificSettings:
    # TODO поддержать аналог $ProjectSpecific::EXTENDED_PATH
    def __init__(self, basic_path='/etc/project_specific/basic_properties.yaml', project='Direct'):
        self.project = project
        self.hostname = ""
        with open(basic_path, 'r') as f:
            self.config = yaml.load(f)

    def _get_data(self, path):
        node = self.config
        path_stack = path[::-1]
        while path_stack:
            node = node[path_stack.pop()]
        return copy.deepcopy(node)

    def svn_url_base(self, type, relative=False):
        if relative:
            url = ''
        else:
            url = self._get_data(['svn_url', self.project]).rstrip('/')
        try:
            url += '/' + self._get_data(['svn_path_for_project', self.project, type]).lstrip('/')
        except KeyError:
            url += '/' + self._get_data(['svn_path', type]).lstrip('/')
        if url != '/':
            url = url.rstrip('/')
        return url

    def svn_root_url(self, relative=False):
        return self.svn_url_base('root', relative=relative)

    def svn_trunk_url(self, relative=False):
        return self.svn_url_base('trunk', relative=relative)

    def svn_branch_url(self, branch, relative=False):
        return self.svn_url_base('branches', relative=relative) + '/' +  branch
    def svn_branch_url_re(self, relative=False):
        return re.escape(self.svn_url_base('branches', relative=relative) + '/') + r'([^/]+)'

    def svn_release_branch_url(self, base_rev, relative=False):
        return self.svn_url_base('releases', relative=relative) + '/release-' +  str(base_rev)
    def svn_release_branch_url_re(self, relative=False):
        return re.escape(self.svn_url_base('releases', relative=relative) + '/release-') + r'([0-9]+)'

    def svn_limtest_branch_url(self, branch, rev1, rev2, relative=False):
        return self.svn_url_base('limtest', relative=relative) + '/' +  '%s-%s-%s' % (branch, str(rev1), str(rev2))
    def svn_limtest_branch_url_re(self, relative=False):
        return re.escape(self.svn_url_base('limtest', relative=relative) + '/') + '%s-%s-%s' % (r'([^/]+)', r'([0-9]+)', r'([0-9]+)')

    def get_startrek_robot_token(self):
        """
        получить токен робота для стартрека
        """
        with open('/etc/direct-tokens/startrek') as fh:
            return fh.readline().strip()

    def get_sign_comment(self, script_name=os.path.basename(sys.argv[0])):
        """
        получить подпись для скриптов работающих со стартреком
        """
        if not self.hostname:
            self.hostname = subprocess.check_output(['hostname', '-f']).strip()
        return u"----\nСкрипт %s с машины %s" % (script_name, self.hostname)

