# -*- coding: utf-8 -*-
from time import sleep

from yamb.errors import YambError


class Updater(object):
    def __init__(self, bot):
        self.bot = bot

    def poll(self,
             chat_id=None,
             timeout=None,
             interval=1,
             pulse=False):
        update = None
        offset = None
        while True:
            try:
                yielded_at_least_once = False
                for update in self.bot.updates(
                    offset=offset,
                    chat_id=chat_id,
                    timeout=timeout,
                ):
                    yielded_at_least_once = True
                    yield update, None
                # start with the new offset next time
                if update:
                    offset = update['id'] + 1
            except YambError as e:
                yield None, e
            finally:
                sleep(interval)  # todo: test me
                if pulse and not yielded_at_least_once:
                    yield None, None
