# -*- coding: utf-8 -*-
import urllib
from copy import deepcopy


def url_join(force_trailing_slash=False, parts=[], query_params={}):
    # todo: test me
    url = '/'.join(part.strip('/') for part in parts if part)
    if force_trailing_slash:
        url += '/'

    if query_params:
        prepared_query_params = deepcopy(query_params)
        for key, value in prepared_query_params.items():
            if isinstance(value, str):
                prepared_query_params[key] = value
            elif isinstance(value, unicode):
                prepared_query_params[key] = value.encode('utf-8')
        # python 3
        # url += '?' + urllib.parse.urlencode(prepared_query_params)
        url += '?' + urllib.urlencode(prepared_query_params)

    return url
