use strict;
use warnings;

use feature 'state';

=head1 NAME
=head1 DESCRIPTION
=head1 COMMENTS
=cut

package GlobalRules;

use Cwd;
use File::chdir;

use Yandex::Shell;


use utf8;

our %ACTIONS = (
    checkout_docs => [
        sub {
            yash_system('ya clone --quiet');
            local $CWD='arcadia';
            yash_system('ya make --checkout -j0 tools/mkdocs_builder');
            yash_system('ya make --checkout -j0 direct/docs');
        },
    ],
    svn_up_docs => [
        sub {
            local $CWD='arcadia';
            yash_system('svn up .');
            yash_system('ya make --checkout -j0 direct/docs');
        },
    ],
    build_docs => [
        sub {
            local $CWD='arcadia';
            yash_system('rm -rfv direct/docs/result');
            yash_system('ya make direct/docs');
            yash_system('mkdir -p direct/docs/result');
            yash_system('tar -xvf direct/docs/docs.tar.gz -C direct/docs/result');
        },
    ],
    serve_docs => [
        sub {
            local $CWD='arcadia/direct/docs/result';
            my $url = join ("", 
                "http://",
                _beta_port(),
                ".beta",
                _beta_number(),
                ".direct.yandex.ru"
            );
            print "\nDocs url: $url\n";
            print "Stop serving the docs with Ctrl-C\n\n";

            system('python -m SimpleHTTPServer ' . _beta_port());
        },
    ],

);


=head2
копия из direct/perl/etc/quasi-make/Beta.pm
=cut
sub _beta_port
{
    state $cwd = getcwd();
    # в пути к каталогу находим первое вхождение элемента beta.(что-то без точек).(число), и считаем, что (число) -- это порт беты
    (my $port = $cwd) =~ s!^.*?/beta\.[^\.]+\.([0-9]+)(?:$|/.*)!$1!;
    return $port;
}
sub _beta_number {
    state $hostname = Sys::Hostname::hostname();
    $hostname =~ /^ppcdev(\d+)$/;
    return $1;
}
sub _beta_hostname {
    return _beta_port() . ".beta" . _beta_number . ".direct.yandex.ru";
}


sub actions
{
    return \%ACTIONS;
}


