use strict;
use warnings;
use utf8;

use Encode qw//;
use JSON::RPC::Dispatch;
use Plack::UTF8Request;
use Router::Simple::Declare;
use Yandex::Queryrec;

my $router = router {
    connect "guess" => {
        handler => "Queryrec",
        action  => "process",
    };
};

my $dispatch = JSON::RPC::Dispatch->new(
    prefix => "Handlers",
    router => $router,
);

my $help = join "\r\n", 'Queryrec — это определитель языка переданной строки.',
'Данный сервис предоставляется поверх JSON-RPC 2.0 и работает в UTF-8',
'Единственный метод — guess, параметр — массив строк, язык которых нужно определить.',
'Результат содержит массив с хешами, соответствующими по порядку строкам запроса',
'Например, на запрос',
'{"method":"guess","params":["Hola Mundo","Bonjour le monde"],"id":"1","jsonrpc":"2.0"}',
'будет ответ',
'{"id":"1","jsonrpc":"2.0","result":',
'[{"spa":0.999947,"rum":0.936131,"pol":0.951131,"cze":0.934832,"eng":0.0368169},{"fre":0.994641,"eng":0.0337919}]}',
'У хешей в массиве ключами являются языки, а значения — вероятность того, что ключ — это язык строки.',
'',
'Поддерживаются множественные запросы также и средствами протокола,',
'например, на запрос',
'[{"method":"guess","params":["Selam Dunya"],"id":"1","jsonrpc":"2.0"},',
'{"method":"guess","params":["Привет, мир"],"id":"2","jsonrpc":"2.0"}]',
'будет ответ',
'[{"id":"1","result":[{"eng":0.0819612,"ind":0.988352,"aze":0.972932,"tur":0.997562}],"jsonrpc":"2.0"},',
'{"id":"2","result":[{"rus":0.998671}],"jsonrpc":"2.0"}]',
'',
'Запросы нужно посылать либо в теле POST-запроса, либо паковать в GET как предложено здесь:',
'http://www.jsonrpc.org/historical/json-rpc-over-http.html#get',
'',
'Чтобы работать с сервисом, а не видеть статус 400, нужно добавить любой символ в путь после слеша';

Yandex::Queryrec::init();

my $app = sub {
    my $env = shift;
    my $request = Plack::UTF8Request->new($env);
    if ($request->path_info =~ /^\/?$/) {
            return [
            '400',
            ['Content-Type' => 'text/plain'],
            ['Bad Request. See /help'],
        ];
    }
    if ($request->path_info =~ /^\/?help$/) {
            return [
            '200',
            ['Content-Type' => 'text/plain; charset=utf-8'],
            [$help],
        ];
    }
    return $dispatch->handle_psgi($env);
};
