use strict;
use warnings;

package Release::Direct;

use base qw/Exporter/;
our @EXPORT = qw/
test_update
test_update_prepare
test_update_message_for_jira
test_update_jira_message
find_packages_to_dmove
dmove_cmd
default_testserver
/;

use Yandex::Shell;

use utf8;

my $BETA_8999_PATH = '/var/www/beta.'.([getpwuid($<)]->[0] || 'svn' ).'.8999';

sub test_update
{
    my (%O) = @_;

    print "direct-test-update $O{version}\n";

    die "test_update: version missed\n" unless $O{version};
    die "test_update: ts_id param missed\n" unless $O{ts_id};

    my $to_update = ref $O{ts_id} eq 'ARRAY' ?  $O{ts_id} : [ $O{ts_id} ];
    for my $ts (@$to_update){
        print "direct-test-update $ts $O{version}\n";
        system("direct-test-update $ts $O{version}") == 0 or die;
    }

    print "\n" x 3;

    return;
}

sub test_update_prepare
{
    my (%O) = @_;
    _update_beta_8999($O{version});
    return;
}


sub _update_beta_8999
{
    my ($version) = @_;

    yash_system(qw!direct-svn-up.pl -v --no-restart!, $BETA_8999_PATH, $version);
    yash_system("$BETA_8999_PATH/protected/maintenance/beta_httpd_conf.pl", 8999, $BETA_8999_PATH, qw!--init!);
}


sub test_update_message_for_jira
{
    my %O = @_;

    my $message = sprintf "обновление ТС доступно по ссылке %s", $O{testupdate_url};

    return $message;
}


sub find_packages_to_dmove
{
    my %O = @_;

    die unless $O{etc_path};

    if ( $] ge "5.018" ){
        for my $repo (qw/direct-trusty direct-common/) {
            print "### $repo:\n";
            yash_system("find-packages-to-dmove.pl -c $O{etc_path}/direct-dmove.yaml -t yandex-direct/debian/control -f $O{from} --repository http://${repo}.dist.yandex.ru/${repo}");
        }
    } else {
        yash_system("find-packages-to-dmove.pl -c $O{etc_path}/direct-dmove.yaml -t yandex-direct/debian/control -f $O{from}");
    }

    return;
}


sub dmove_cmd
{
    return 'beta-update';
}


sub default_testserver
{
    return "";
}


1;
