use strict;
use warnings;

package Release::Directmod;

use base qw/Exporter/;
our @EXPORT = qw/
test_update
test_update_prepare
test_update_message_for_jira
create_conductor_ticket
find_packages_to_dmove
dmove_cmd
default_testserver
/;

use Yandex::Shell;

use utf8;

sub test_update
{
    my (%O) = @_;

    my $ts = main::var_value('TESTSERVER') =~ s/^.*\(([a-z0-9]+)\)$/$1/r;
    die "can't parse testserver variable: '".main::var_value('TESTSERVER')."'" unless $ts;

    my $cmd = "directmod-test-update $ts $O{version}";
    print "$cmd\n";

    die "test_update: version missed\n" unless $O{version};

    system($cmd) == 0 or die ;

    return;
}

sub test_update_prepare
{
    return;
}

sub test_update_message_for_jira
{
    return "ТС обновлена";
}

sub create_conductor_ticket
{
    my $type = main::var_value('RELEASE_TYPE');
    if ( $type eq "RC" ){
        die "unsupported";
    } elsif ( $type eq "STABLE" ){
        local $ENV{CONDUCTOR_COMMENT} = main::var_value('RELEASE_ISSUE_KEY');
        yash_system("./idm --host=prod --version=".main::var_value('PKG_VERSION'));
    } else {
        die "unsupported release type '$type', stop\n";
    }
}

sub find_packages_to_dmove
{
    my %O = @_;

    die unless $O{etc_path};

    yash_system("find-packages-to-dmove.pl -c $O{etc_path}/directmod-dmove.yaml -t direct-moderate/debian/control -f $O{from}");

    return;
}


sub dmove_cmd
{
    return 'ssh updater@ppcdev2.yandex.ru';
}


sub default_testserver
{
    return "test1";
}


1;
