# crontab for releaser of {{ settings.PROJECT }} project{% if run_on_frontend %} for frontend{% endif %}

{% if settings.ADMIN_MAIL %}
MAILTO={{ settings.ADMIN_MAIL }}
{% endif %}

{% if not run_on_frontend %}

# fetch new revisions from svn to database
* * * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname svnfetch_{{ settings.PROJECT }} -- /usr/bin/django-admin svnfetch --settings=releaser.settings.{{ settings.PROJECT }} --pythonpath=/var/www/releaser/

{% if settings.JIRA_RELEASES_FILTER_ID %}
# fetch new and update old releases from jira
*/3 * * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname fetch_releases_{{ settings.PROJECT }} -- /usr/bin/django-admin fetch_releases --settings=releaser.settings.{{ settings.PROJECT }} --pythonpath=/var/www/releaser/
{% endif %}

{% if settings.RELEASEPLANNING_ENABLED %}
*/5 * * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname process_releaseplans_{{ settings.PROJECT }} -- /usr/bin/django-admin process_releaseplans --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
{% endif %}

{% if settings.HOTFIXING_ENABLED %}
*/6 * * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname process_hotfix_requests_{{ settings.PROJECT }} -- /usr/bin/django-admin process_hotfix_requests --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
#55 13 * * 1,2,3,4,5 {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname reminder_for_release_engineer_{{ settings.PROJECT }} -- /usr/bin/django-admin reminder_for_release_engineer --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
#55 16 * * 1,2,3,4   {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname reminder_for_release_engineer_{{ settings.PROJECT }} -- /usr/bin/django-admin reminder_for_release_engineer --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser

*/3 * * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname notify_on_deploy_{{ settings.PROJECT }} -- /usr/bin/django-admin notify_on_deploy --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
#17,47 * * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname update_tracker_on_deploy_{{ settings.PROJECT }} -- /usr/bin/django-admin update_tracker_on_deploy --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
{% endif %}

{% if settings.PROJECT == 'direct' %}
#13,43 * * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname update_tracker_on_deploy_dna_{{ settings.PROJECT }} -- /usr/bin/django-admin update_tracker_on_deploy_dna --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
{% endif %}

{% if settings.MIGRATIONS_ENABLED %} 
*/7 * * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname fetch_migrations_{{ settings.PROJECT }} -- /usr/bin/django-admin fetch_migrations --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
{% endif %}

{% if settings.GAP_ENABLED %}
#7 */4 * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname fetch_gap_{{ settings.PROJECT }} -- /usr/bin/django-admin fetch_gap --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser 
{% endif %}

{% if settings.PROJECT == 'direct' or settings.PROJECT == 'javadirect' %}
*/5 * * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname close_deployed_releases_{{ settings.PROJECT }} -- /usr/bin/django-admin close_deployed_releases --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
{% endif %}

{% if settings.PROJECT == 'direct' or settings.PROJECT == 'javadirect' %}
0 * * * 1-5 {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} COMMENT_REGRESSIONS=1 /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname get_release_statistics_{{ settings.PROJECT }} -- /usr/bin/django-admin get_release_statistics --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
{% endif %}

#{% if settings.TESTUPDATE_ENABLED %}
#5,35 * * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname testupdate_yamb_{{ settings.PROJECT }} -- /usr/bin/django-admin testupdate_yamb --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
#{% endif %}

{% if settings.TESTUPDATE_JIRA_COMMENTS_ENABLED %}
*/5 * * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname tracker_comment_on_update_ts_{{ settings.PROJECT }} -- /usr/bin/django-admin tracker_comment_on_update_ts --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
{% endif %}

0 1,2 * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname get_uids_from_staff_{{ settings.PROJECT }} -- /usr/bin/django-admin get_uids_from_staff --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser

0 */3 * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname autobetas_killer_{{ settings.PROJECT }} -- /usr/bin/django-admin autobetas_killer --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser

{% if settings.FAILED_BUILDS_NOTIFY_ENABLED %}
0 12,15,18 * * 1-5 {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname failed_builds_notify_{{ settings.PROJECT }} -- /usr/bin/django-admin failed_builds_notify --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
{% endif %}

{% for task in tasks %}
{% if task.launch_tag %}
{{ task.schedule }} {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname run_tasks_{{ settings.PROJECT }} -- /usr/bin/django-admin run_tasks --launch-tag {{ task.launch_tag }} --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
{% else %}
{{ task.schedule }} {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/switchman -c /etc/tabula-switchman.conf -g tabula --lockname run_tasks_{{ settings.PROJECT }} -- /usr/bin/django-admin run_tasks --name {{ task.name }} --settings=releaser.settings.{{ settings.PROJECT }}  --pythonpath=/var/www/releaser
{% endif %}
{% endfor %}

{% else %}

{% if settings.PROJECT == 'direct' %}
14 */3 * * * {{ settings.CRON_USER }} {{ settings.CRON_ENV_VARS }} /usr/bin/flock -n /var/www/releaser/htdocs/db /usr/local/bin/run-schema-spy.pl --out /var/www/releaser/htdocs/db --db-schema-svn svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/direct/perl/db_schema
{% endif %}

{% endif %}
