# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'AutoBeta'
        db.create_table('autobeta_autobeta', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('port', self.gf('django.db.models.fields.IntegerField')(default=-1)),
            ('source_type', self.gf('django.db.models.fields.IntegerField')(default=1)),
            ('source_branch', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['svnlog.SvnPath'], null=True)),
            ('source_host', self.gf('django.db.models.fields.related.ForeignKey')(related_name='+', null=True, to=orm['versionica.Host'])),
            ('source_hostgroup', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['versionica.HostGroup'], null=True)),
            ('source_working_copy', self.gf('django.db.models.fields.CharField')(default='', max_length=200)),
            ('jira_issue', self.gf('django.db.models.fields.CharField')(default='', max_length=50, db_index=True)),
            ('author', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['users.User'])),
            ('target_host', self.gf('django.db.models.fields.related.ForeignKey')(related_name='+', to=orm['versionica.Host'])),
            ('comment', self.gf('django.db.models.fields.CharField')(max_length=500)),
            ('update_period', self.gf('django.db.models.fields.IntegerField')(default=-1)),
            ('current_revision', self.gf('django.db.models.fields.IntegerField')(default=-1)),
            ('last_update_time', self.gf('django.db.models.fields.DateTimeField')(null=True)),
            ('status', self.gf('django.db.models.fields.IntegerField')(default=1)),
            ('conf_name', self.gf('django.db.models.fields.CharField')(default='', max_length=50)),
        ))
        db.send_create_signal('autobeta', ['AutoBeta'])

    def backwards(self, orm):

        # Deleting model 'AutoBeta'
        db.delete_table('autobeta_autobeta')

    models = {
        'autobeta.autobeta': {
            'Meta': {'object_name': 'AutoBeta'},
            'author': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"}),
            'comment': ('django.db.models.fields.CharField', [], {'max_length': '500'}),
            'conf_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'current_revision': ('django.db.models.fields.IntegerField', [], {'default': '-1'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'jira_issue': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'last_update_time': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'port': ('django.db.models.fields.IntegerField', [], {'default': '-1'}),
            'source_branch': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnPath']", 'null': 'True'}),
            'source_host': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'+'", 'null': 'True', 'to': "orm['versionica.Host']"}),
            'source_hostgroup': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.HostGroup']", 'null': 'True'}),
            'source_type': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'source_working_copy': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '200'}),
            'status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'target_host': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'+'", 'to': "orm['versionica.Host']"}),
            'update_period': ('django.db.models.fields.IntegerField', [], {'default': '-1'})
        },
        'svnlog.svnpath': {
            'Meta': {'object_name': 'SvnPath'},
            'path': ('django.db.models.fields.CharField', [], {'max_length': '1000'}),
            'path_hash': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '64'}),
            'path_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'users.user': {
            'Meta': {'object_name': 'User'},
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'uid': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'versionica.host': {
            'Meta': {'object_name': 'Host'},
            'host_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        },
        'versionica.hostgroup': {
            'Meta': {'object_name': 'HostGroup'},
            'group_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'main_host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']", 'null': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        }
    }

    complete_apps = ['autobeta']
