# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'AutoBetaLog'
        db.create_table('autobeta_autobetalog', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('autobeta', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['autobeta.AutoBeta'], null=True)),
            ('logtime', self.gf('django.db.models.fields.DateTimeField')(db_index=True)),
            ('type', self.gf('django.db.models.fields.IntegerField')(default=10)),
            ('logtext', self.gf('django.db.models.fields.TextField')(max_length=33554432, null=True)),
        ))
        db.send_create_signal('autobeta', ['AutoBetaLog'])

        # Adding field 'AutoBeta.working_copy_path'
        db.add_column('autobeta_autobeta', 'working_copy_path', self.gf('django.db.models.fields.CharField')(default='', max_length=200), keep_default=False)

    def backwards(self, orm):

        # Deleting model 'AutoBetaLog'
        db.delete_table('autobeta_autobetalog')

        # Deleting field 'AutoBeta.working_copy_path'
        db.delete_column('autobeta_autobeta', 'working_copy_path')

    models = {
        'autobeta.autobeta': {
            'Meta': {'object_name': 'AutoBeta'},
            'author': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"}),
            'comment': ('django.db.models.fields.CharField', [], {'max_length': '500'}),
            'conf_name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'current_revision': ('django.db.models.fields.IntegerField', [], {'default': '-1'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'jira_issue': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50', 'db_index': 'True'}),
            'last_update_time': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'port': ('django.db.models.fields.IntegerField', [], {'default': '-1'}),
            'source_branch': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnPath']", 'null': 'True'}),
            'source_host': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'+'", 'null': 'True', 'to': "orm['versionica.Host']"}),
            'source_hostgroup': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.HostGroup']", 'null': 'True'}),
            'source_type': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'source_working_copy': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '200'}),
            'status': ('django.db.models.fields.IntegerField', [], {'default': '1'}),
            'target_host': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'+'", 'to': "orm['versionica.Host']"}),
            'update_period': ('django.db.models.fields.IntegerField', [], {'default': '-1'}),
            'working_copy_path': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '200'})
        },
        'autobeta.autobetalog': {
            'Meta': {'object_name': 'AutoBetaLog'},
            'autobeta': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['autobeta.AutoBeta']", 'null': 'True'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logtext': ('django.db.models.fields.TextField', [], {'max_length': '33554432', 'null': 'True'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True'}),
            'type': ('django.db.models.fields.IntegerField', [], {'default': '10'})
        },
        'svnlog.svnpath': {
            'Meta': {'object_name': 'SvnPath'},
            'path': ('django.db.models.fields.CharField', [], {'max_length': '1000'}),
            'path_hash': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '64'}),
            'path_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'users.user': {
            'Meta': {'object_name': 'User'},
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'uid': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        },
        'versionica.host': {
            'Meta': {'object_name': 'Host'},
            'host_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        },
        'versionica.hostgroup': {
            'Meta': {'object_name': 'HostGroup'},
            'group_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'main_host': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['versionica.Host']", 'null': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'})
        }
    }

    complete_apps = ['autobeta']
