# -* encoding: utf-8 -*-
import json
from django.http import HttpResponse, Http404
from django.shortcuts import render_to_response, redirect
from django.template import RequestContext
from django.contrib.auth.decorators import login_required
from django.db.models import Q, Min, Count, Max
import math, sys, os, random, time, datetime, string, re
from datetime import timedelta
from socket import gethostbyaddr
import yaml, re
from urllib import urlencode
import tempfile
from subprocess import call
from startrek_client import Startrek
from releaser.startrek.tools import get_startrek_robot_token
from project_specific import ProjectSpecificSettings

from releaser.yambclient.client import YambClient
from django.conf import settings
from releaser.rights.tools import allowed, has_right
from releaser.autobeta.models import *
from django.db import connection

def index(r):
    if not settings.AUTOBETA_ENABLED:
        raise Http404

    extra_param = r.REQUEST.get('extra', '').strip()
    advanced_params_allowed = extra_param != '' and has_right(r.user.username, ['tabula_superuser'])

    autobetas = AutoBeta.objects.filter(~Q(status__in=[AutoBeta.STATUS_DELETED])).select_related('author__login', 'author__name', 'target_host__name', 'source_branch__path').order_by('author__login')

    frequent_actions = settings.AUTOBETA_FREQUENT_ACTIONS

    last_log_id_rows = AutoBetaLog.objects.filter(autobeta_id__in=[a.id for a in autobetas]).values('autobeta_id').annotate(last_log_id=Max('id'))
    last_log_events = AutoBetaLog.objects.filter(id__in=[row['last_log_id'] for row in last_log_id_rows]).values('autobeta_id', 'type')
    last_event_by_autobeta_id = {}
    for event in last_log_events:
        last_event_by_autobeta_id[event['autobeta_id']] = event

    autobetas = list(autobetas)
    autobetas.sort( key=lambda a: a.id, reverse=True )
    for autobeta in autobetas:
        autobeta.expiration_warning = False
        if autobeta.expiration_time and datetime.now() > autobeta.expiration_time - timedelta(days=settings.AUTOBETA_WARNING_DAYS):
            autobeta.expiration_warning = True
        autobeta.expiration_time = autobeta.expiration_time_to_str()

        tickets = re.findall(settings.ISSUE_KEY_REGEXP, autobeta.comment.upper(), re.I)
        tickets.extend(re.findall(settings.ISSUE_KEY_REGEXP, autobeta.source_branch.path.upper(), re.I))
        autobeta.tickets = [{'key' : ticket} for ticket in list(set(tickets))]

        if autobeta.id in last_log_events:
            last_log_event = last_log_events[autobeta.id]
            autobeta.has_errors = last_log_event['type'] == AutoBetaLog.TYPE_ERROR
        else:
            autobeta.has_errors = False

    startrek = Startrek(token=get_startrek_robot_token(), useragent=settings.USER_AGENT)
    tickets_to_find = ','.join([ticket['key'] for ab in autobetas for ticket in ab.tickets])
    if tickets_to_find:
        required_issues = startrek.issues.find('Key: %s' % ','.join([ticket['key'] for ab in autobetas for ticket in ab.tickets]))
    else:
        required_issues = []
    tickets = {i.key: {'status' : i.status.display, 'summary': i.summary} for i in required_issues}

    for autobeta in autobetas:
        for ticket in autobeta.tickets:
            ticket['status'] = tickets[ticket['key']]['status']
            ticket['summary'] = tickets[ticket['key']]['summary']

    vars = {
            'autobetas': autobetas,
            'possible_hosts': sorted(settings.AUTOBETA_HOSTS),
            'frequent_actions': frequent_actions,
            'advanced_params_allowed': advanced_params_allowed,
            'project': settings.PROJECT,
            }


    response = render_to_response('autobeta/index.html',
            vars,
            context_instance=RequestContext(r)
            )

    #for query in connection.queries:
    #    print query['sql']

    return response


@login_required
@allowed(['developer', 'test_engineer'])
def schedule(r):
    if not settings.AUTOBETA_ENABLED:
        raise Http404

    id = r.REQUEST.get('id', '').strip()
    actions_str = r.REQUEST.get('actions', '').strip()
    comment = r.REQUEST.get('comment', '').strip()

    ab = AutoBeta.objects.filter(id=id).filter(~Q(status__in=[AutoBeta.STATUS_DELETED]))[0]

    # TODO проверка [\w\s,;]+

    actions = re.split(u'[,:;]+', actions_str)
    actions = [ a for a in list(set(actions)) if re.match(r'^[\w\- ]+$', a) ]

    ab.actions = ','.join(actions)
    ab.comment = comment
    ab.save()

    path = r.REQUEST.get('retpath', '/autobeta')
    return redirect(path)


@login_required
@allowed(['developer', 'test_engineer'])
def create(r):
    if not settings.AUTOBETA_ENABLED:
        raise Http404

    branch = r.REQUEST.get('branch', '').strip()
    host = r.REQUEST.get('host', '').strip()
    port = r.REQUEST.get('port', '').strip()
    port = -1 if port == '' else int(port)
    if not has_right(r.user.username, ['tabula_superuser']):
        port = -1

    if re.match(r'/', branch):
        branch_path = branch
    else:
        branch_path = "/branches/%s" % branch

    if re.match(r'/trunk', branch_path):
        expiration_time = None
    else:
        expiration_time = datetime.now() + timedelta(days=settings.AUTOBETAS_LIFETIME)

    host_obj = Host.objects.get(name=host)
    if not host_obj.name in settings.AUTOBETA_HOSTS:
        raise Exception("forbidden host %s, use one of: %s" % (host_obj.name, settings.AUTOBETA_HOSTS))

    same_host_count = AutoBeta.objects.filter(target_host = host_obj).filter(~Q(status = AutoBeta.STATUS_DELETED)).count()
    if same_host_count >= settings.AUTOBETAS_PER_HOST:
        raise Exception("too many autobetas for host %s (%s)" % (host_obj.name, settings.AUTOBETAS_PER_HOST))

    branch_obj = SvnPath.objects.get(path=branch_path)
    author = User.objects.get(login=r.user.username)

    rec = AutoBeta.objects.create(
            target_host = host_obj,
            source_branch = branch_obj,
            author = author,
            port = port,
            expiration_time = expiration_time,
            )

    return redirect('/autobeta')


@login_required
@allowed(['developer', 'test_engineer', 'manager'])
def extend_expiration_time(r):
    id = r.REQUEST.get('id', '').strip()

    ab = AutoBeta.objects.get(pk=id)
    ab.expiration_time += timedelta(days=settings.AUTOBETAS_LIFETIME)
    ab.save()

    return redirect('/autobeta')


@login_required
@allowed(['developer', 'test_engineer', 'manager'])
def delete(r):
    id = r.REQUEST.get('id', '').strip()

    ab = AutoBeta.objects.get(pk=id)

    #if ab.author.login != r.user.username:
    #    raise Exception("PermissionDenied")

    ab.status = AutoBeta.STATUS_TO_DELETE
    ab.save()

    return redirect('/autobeta')


def instructions(r):
    pretty = r.REQUEST.get('pretty', '').strip()
    autobetas = AutoBeta.objects.all().filter(~Q(status__in=[AutoBeta.STATUS_DELETED]))
    todo = {
            'autobetas': [],
            }

    for ab in autobetas:
        todo_item = ab.to_dict()
        source_branch = todo_item['source_branch']
        if source_branch == '/trunk' and settings.PROJECT == 'direct':
            source_branch = '/trunk/arcadia/direct/perl'
        if re.match(r'/branches/[^/]+$', source_branch) and settings.PROJECT == 'direct':
            source_branch = source_branch.replace('/branches', '/branches/direct/perl')
        todo_item['source_branch'] = source_branch
        todo['autobetas'] += [ todo_item ]

    if pretty == '':
        json_data = json.dumps(todo, sort_keys=True)
    else:
        json_data = json.dumps(todo, sort_keys=True, indent=2)

    return HttpResponse(json_data, mimetype="application/javascript")


def show_log(r):
    if not settings.AUTOBETA_ENABLED:
        raise Http404

    id = r.REQUEST.get('id', '0').strip()
    id = int(id);
    if id > 0:
        ab = AutoBeta.objects.filter(id=id).filter(~Q(status__in=[AutoBeta.STATUS_DELETED]))[0]
    else:
        ab = {}

    records = AutoBetaLog.objects.filter(autobeta_id=id).order_by('-logtime')[0:100]

    vars = {
            'id': id,
            'records': records,
            'autobeta': ab,
            }
    return render_to_response('autobeta/showlog.html',
            vars,
            context_instance=RequestContext(r)
            )


def worker_done(r):
    report_json = r.REQUEST.get('report', '')
    report = json.loads(report_json)

    NOW = datetime.now()

    for rec in report['autobetas']:
        if not 'id' in rec:
            AutoBetaLog.objects.create(
                    type = AutoBetaLog.TYPE_ERROR,
                    logtext = "no id, skipping: %s\n" % rec
                    )
            continue

        try:
            # TODO выбирать беты со статусом не deleted
            ab = AutoBeta.objects.get(id=rec['id'])
        except AutoBeta.DoesNotExist:
            AutoBetaLog.objects.create(
                    type = AutoBetaLog.TYPE_ERROR,
                    logtext = "autobeta doesn't exist (id=%s), skipping: %s" % (rec['id'], rec)
                    )
            continue

        if not 'result' in rec:
            rec['result'] = ''

        l = AutoBetaLog(
                type = AutoBetaLog.TYPE_INFO,
                autobeta_id = ab.id,
                )


        if rec['result'] == 'created':
            ab.port = rec['port']
            ab.working_copy_path = rec['path']
            ab.status = AutoBeta.STATUS_WORK
            ab.current_revision = rec['revision']
            l.logtext = "created"
        elif rec['result'] == 'deleted':
            ab.status = AutoBeta.STATUS_DELETED
            l.logtext = "deleted"
        elif rec['result'] == 'updated':
            ab.status = AutoBeta.STATUS_WORK
            ab.current_revision = rec['revision']
            l.logtext = "updated"
        else:
            l.type = AutoBetaLog.TYPE_ERROR
            l.logtext = "unexpected status '%s', skipping: %s" % (rec['result'], rec)
        # TODO фильтрацию по target_host и ip, с которого пришел отчет -- как в Версионике
        if 'actions_result' in rec and rec['actions_result'] == 'ok':
            l.logtext += "; actions done: %s" % ab.actions
            ab.actions = ''
        if 'errors' in rec and len(rec['errors']) > 0:
            l.type = AutoBetaLog.TYPE_ERROR
            l.logtext += "errors: %s" % (rec['errors'])
        ab.last_update_time = NOW
        ab.save()
        l.save()

        if l.type == AutoBetaLog.TYPE_ERROR:
            try:
                yamb = YambClient()
                to = ab.author.login
                msg = u"""(Табула) Проблемы с автобетой %s
%s
""" % (ab.port, l.logtext)
                yamb.send_message(to, msg)
            except Exception, e:
                pass

    return HttpResponse("ok", mimetype="text/plain; charset=utf-8")

def sync_create(r):
    branch = r.REQUEST.get('branch', '').strip()
    host = r.REQUEST.get('host', '').strip()
    port = r.REQUEST.get('port', '').strip()
    dna = r.REQUEST.get('dna', '').strip()
    java_svn = r.REQUEST.get('java_svn', '').strip()
    js_templater = r.REQUEST.get('js_templater', '').strip()

    port = -1 if port == '' else int(port)
    if not has_right(r.user.username, ['tabula_superuser']):
        port = -1

    if dna and not re.match(r'branch:', dna):
        dna = "branch:%s" % (dna)

    if java_svn and not re.match(r'branch:', java_svn):
        java_svn = "branch:%s" % (java_svn)

    project_specific = ProjectSpecificSettings(project=settings.PROJECT.capitalize())
    if re.match(r'/trunk', branch):
        # is_trunk когда-то для транковых бет не проставляли expiration_time, но на самом деле надо.
        # если нужна неудаляющаяся автобет -- надо или вручную стереть exp_time из базы,
        # или делать спец-галку в интерфейсе
        #is_trunk = True
        branch_path = project_specific.svn_trunk_url(relative=True)
        fake_branch_path = '/trunk'
    elif re.match(r'/', branch):
        branch_path = branch
    else:
        branch_path = project_specific.svn_branch_url(branch.strip('/'), relative=True)
        fake_branch_path = '/branches/%s' % branch.strip('/')

    expiration_time = datetime.now() + timedelta(days=settings.AUTOBETAS_LIFETIME)

    host_obj = Host.objects.get(name=host)
    if not host_obj.name in settings.AUTOBETA_HOSTS:
        raise Exception("forbidden host %s, use one of: %s" % (host_obj.name, settings.AUTOBETA_HOSTS))

    same_host_count = AutoBeta.objects.filter(target_host = host_obj).filter(~Q(status = AutoBeta.STATUS_DELETED)).count()
    if same_host_count >= settings.AUTOBETAS_PER_HOST:
        raise Exception("too many autobetas for host %s (%s)" % (host_obj.name, settings.AUTOBETAS_PER_HOST))

    try:
        branch_obj = SvnPath.objects.get(path=branch_path)
    except SvnPath.DoesNotExist:
        # раньше объекты SvnPath создавал svnfetch, но после переезда в Аркадию это делается в javadirect, поэтому берём дело в свои руки
        branch_obj, _ = SvnPath.objects.get_or_create(path_hash=SvnPath.hash(branch_path), path=branch_path)
    author = User.objects.get(login=r.user.username)

    rec = AutoBeta.objects.create(
            target_host = host_obj,
            source_branch = branch_obj,
            author = author,
            port = port,
            status = AutoBeta.STATUS_CREATING,
            expiration_time = expiration_time,
            )
    autobeta_id = rec.id

    # TODO: вместо --relative-svn-path передавать --branch, запретить произвольные пути
    cmd = 'ssh updater@%s direct-create-beta --autobeta --relative-svn-path %s' % (host, branch_path)
    if port != -1:
        cmd += " -p %s" % (port)

    if dna != '':
        cmd += " --dna %s" % (dna)

    if java_svn != '':
        cmd += " --java-svn %s" % (java_svn)

    if js_templater != '':
        cmd += " --js-templater"

    logfile = tempfile.TemporaryFile()
    status = call(cmd, shell = True, stdout=logfile, stderr=logfile)
    logfile.seek(0)
    create_log = logfile.read()
    url = ''
    path = ''
    revision = 0
    for line in create_log.splitlines():
        m = re.match(r'path:\s*(\S+\.([0-9]+))$', line)
        if m:
            path = m.group(1)
            port = m.group(2)
        m = re.match(r'url:\s*(\S+)', line)
        if m:
            url = m.group(1)

        m = re.match(r'(?:At|Updated\s+to)\s+revision\s+([0-9]+)', line)
        if m:
            revision = m.group(1)
        if port > 0 and url != '' and revision > 0:
            break
    if status == 0:
        rec.status = AutoBeta.STATUS_WORK
        rec.port = port
        rec.working_copy_path = path
        rec.current_revision = revision
        rec.last_update_time = datetime.now()

        l = AutoBetaLog(
                type = AutoBetaLog.TYPE_INFO,
                autobeta_id = rec.id,
                logtext="created"
                )
        l.save()
    else:
        rec.status = AutoBeta.STATUS_DELETED
    rec.save()

    return render_to_response('autobeta/create_result.html',
        {
            'status': status,
            'url': url,
            'create_log': create_log,
        },
        context_instance=RequestContext(r)
        )

    return redirect('/autobeta')

def sync_mk(r):
    id = r.REQUEST.get('id', '').strip()
    action = r.REQUEST.get('action', '').strip()
    if not re.match(r'^[\w\- ]+$', action):
        raise Exception('invalid action name "%s"' % (action))

    ab = AutoBeta.objects.get(pk=id)
    if ab.status == AutoBeta.STATUS_DELETED:
        raise Exception('cannot perform action on deleted autobeta')

    cmd = 'ssh updater@%s direct-mk %s %s --lock beta-%s' % (ab.target_host, ab.working_copy_path, action, ab.port)
    if action == 'up':
        cmd = cmd + ' -- --verbose'
    logfile = tempfile.TemporaryFile()
    status = call(cmd, shell = True, stdout=logfile, stderr=logfile)
    logfile.seek(0)
    mk_log = logfile.read()
    sys.stderr.write(mk_log)
    revision = 0
    if status == 0 and action == 'up':
        for line in mk_log.splitlines():
            m = re.match(r'revision:\s*([0-9]+)', line)
            if m:
                revision = m.group(1)
                ab.current_revision = revision
                ab.last_update_time = datetime.now()
                ab.save()

    return render_to_response('autobeta/mk_result.html',
        {
            'revision': revision,
            'action': action,
            'mk_log': mk_log,
            'status': status,
            'url': ab.url,
        },
       context_instance=RequestContext(r)
    )
