# -* encoding: utf-8 -*-
from django.http import HttpResponse, Http404, HttpResponseNotFound
from django.shortcuts import render_to_response, redirect
from django.template import RequestContext
from django.contrib.auth.decorators import login_required
import json
from subprocess import call
import sys, time, tempfile, re

from django.conf import settings
from releaser.rights.tools import allowed, has_right

@login_required
def index(r):
    branch = r.GET.get('branch', '').strip()
    branch = re.sub(r'^.*/', '', branch)
    return render_to_response('automerge/index.html',
            {
                "branch": branch,
                },
            context_instance=RequestContext(r)
            )

@login_required
@allowed(['developer', 'test_engineer'])
def merge(r):
    branch = r.GET.get('branch', '').strip()
    host = settings.HOST_FOR_SVN_MERGE
    login = r.user.username

    if branch == '':
        return HttpResponse('{"status":1,"merge_log":"empty branch"}', mimetype='application/javascript')
    if login == '':
        return HttpResponse('{"status":1,"merge_log":"undefined login for performing merge"}', mimetype='application/javascript')
    if host == '':
        return HttpResponse('{"status":1,"merge_log":"undefined host for performing merge"}', mimetype='application/javascript')

    logfile = tempfile.TemporaryFile()
    cmd = 'ssh updater@%s direct-svn-merge -b %s -y --requester %s' % (host, branch, login )
    status = call(cmd, shell=True, stdout=logfile, stderr=logfile)
    logfile.seek(0)
    merge_log = logfile.read()

    return HttpResponse(
            json.dumps(
                {
                    'status': status,
                    'merge_log': merge_log,
                    }
                ),
                mimetype='application/javascript'
            )
