#!/bin/sh

project=$1
if [ -z $project ]
then
    echo "no project name (e. g. direct, directmod, geocontext) specified"
    exit 1
fi

if [ ! `pwd | grep -E '/releaser$'` ]
then
    echo "must be in /releaser subdir"
    exit 1
fi
port=`pwd | sed -e 's!.*/beta\.[^/]\+\.\([0-9]\+\)/releaser$!\1!'`

export PYTHONPATH=/opt/direct-py/startrek-python-client-sni-fix:$PYTHONPATH

cmd="django-admin runserver tabula-dev.man.yp-c.yandex.net:$port --settings=releaser.settings.$project --pythonpath=../ --ipv6"
echo "running: $cmd"
exec $cmd
