# -* encoding: utf-8 -*-
from django.http import HttpResponse
from django.shortcuts import render_to_response
from django.template import RequestContext
import json
import urllib2, re, itertools
from datetime import datetime, date
import sys


from django.conf import settings

# TODO:
# 1. Сделать обработку ошибок: логин не найден, группа не найдена (для проверок групп нужен будет ещё один
#    запрос к staff API: https://staff-api.yandex-team.ru/v3/groups?_doc=1)
# 2. Сделать обработку случая, когда людей в результате больше 1000? Навряд ли мы скоро на это наткнёмся,
#    но для аккуратности стоит.
def index(r):
    if 'logins' in r.REQUEST or 'groups' in r.REQUEST:
        logins = [v for v in r.REQUEST.get('logins', '').split(' ') if v]
        groups = [v for v in r.REQUEST.get('groups', '').split(' ') if v]
    else:
        logins = settings.BIRTHDAYS_LOGINS
        groups = settings.BIRTHDAYS_GROUPS

    query_groups = []
    query_ancestors = []
    for group in groups:
        if group.endswith('!'):
            group = group[:-1]
            query_groups.append(group)
        else:
            query_groups.append(group)
            query_ancestors.append(group)

    query_parts = []
    if query_groups:
        query_parts.append('groups.group.url in (' + ','.join(['"' + group + '"' for group in query_groups]) + ')')
    if query_ancestors:
        query_parts.append('groups.group.ancestors.url in (' + ','.join(['"' + group + '"' for group in query_ancestors]) + ')')
    if logins:
        query_parts.append('(' + ' or '.join(['login == "' + login + '"' for login in logins]) + ')')

    peoples = []
    if query_parts:
        query = 'official.is_dismissed == false and (' + ' or '.join(query_parts)  + ')'
        print query

        url = (settings.STAFF_API_URL + 'persons?' +
            '_query=' + urllib2.quote(query) + '&' +
            '_fields=personal.birthday,name,login,official.position,location.office.name&_limit=1000')

        token = open(settings.STAFF_API_TOKEN_FILE).readline().rstrip()
        request = urllib2.Request(url, headers={'Authorization' : 'OAuth ' + token})
        contents = urllib2.urlopen(request).read()

        result = json.loads(contents)
        peoples = [
            {
                'login' : person['login'],
                'first_name' : person['name']['first']['ru'],
                'last_name' : person['name']['last']['ru'],
                'position' : person['official']['position']['ru'],
                'birthday' : person['personal']['birthday'],
            }
            for person in result['result'] if person['personal']['birthday'] is not None
        ]

    today_str = date.today().strftime("%m-%d")
    year = date.today().year
    for h in peoples:
        bday_str = h['birthday'][5:]
        bday_year = year if bday_str >= today_str else year + 1
        h['next_birthday'] = "%d-%s" % (bday_year, bday_str)
        try:
            h['birthday_md'] = datetime.strptime(h['next_birthday'], "%Y-%m-%d").strftime("%d %b, %a")
        except ValueError, e:
            try:
                h['birthday_md'] = datetime.strptime(h['birthday'], "%Y-%m-%d").strftime("%d %b")
            except Exception, e:
                h['birthday_md'] = ''

    peoples = sorted(peoples, key=lambda x: x['next_birthday'])

    stash = {
        'peoples': peoples,
        'errors': [],
        'logins': ' '.join(logins),
        'groups': ' '.join(groups)
        }
    return render_to_response('birthdays/index.html', stash, context_instance=RequestContext(r))
