# -* encoding: utf-8 -*-

from textwrap import dedent

from django.conf import settings

from releaser.subscriptions.events_base import BaseEvent, event

@event
class BuildBotTrunkBuildFailed(BaseEvent):
    event_type = 'trunk_build_failed'

    @staticmethod
    def display_subscription(sub):
        return u'Неудачные сборки на транке'

    def notification_content_for_yamb(self, recipient):
        return dedent(u"""\
            (Табула/{project}) на коммите {rev} сломалась сборка {builder}
            Коммит: {tabula_url}/svnreview/add/{rev}
            Список всех коммитов: {tabula_url}/svnlog
            Buildbot: {buildbot_url}/waterfall
            """.format(
                project=settings.NAME,
                tabula_url='https://' + settings.RELEASER_DNS,
                buildbot_url=settings.BUILDBOT_URL,
                builder=self.event_data['builder_name'],
                rev=self.event_data['revision']
                )
            )
