# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'BuildBotBuilder'
        db.create_table('cifront_buildbotbuilder', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(default='', max_length=100)),
            ('description', self.gf('django.db.models.fields.CharField')(default='', max_length=2000)),
        ))
        db.send_create_signal('cifront', ['BuildBotBuilder'])

        # Adding model 'BuildBotSingleBuild'
        db.create_table('cifront_buildbotsinglebuild', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('builder', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['cifront.BuildBotBuilder'])),
            ('rev', self.gf('django.db.models.fields.IntegerField')()),
            ('logtime', self.gf('django.db.models.fields.DateTimeField')()),
            ('status', self.gf('django.db.models.fields.IntegerField')()),
            ('status_text', self.gf('django.db.models.fields.CharField')(default='', max_length=100)),
        ))
        db.send_create_signal('cifront', ['BuildBotSingleBuild'])

    def backwards(self, orm):

        # Deleting model 'BuildBotBuilder'
        db.delete_table('cifront_buildbotbuilder')

        # Deleting model 'BuildBotSingleBuild'
        db.delete_table('cifront_buildbotsinglebuild')

    models = {
        'cifront.buildbotbuilder': {
            'Meta': {'object_name': 'BuildBotBuilder'},
            'description': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '2000'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100'})
        },
        'cifront.buildbotsinglebuild': {
            'Meta': {'object_name': 'BuildBotSingleBuild'},
            'builder': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['cifront.BuildBotBuilder']"}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {}),
            'rev': ('django.db.models.fields.IntegerField', [], {}),
            'status': ('django.db.models.fields.IntegerField', [], {}),
            'status_text': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '100'})
        }
    }

    complete_apps = ['cifront']
