# -*- coding:utf-8 -*-
from django.db import models

from datetime import datetime

class BuildBotBuilder(models.Model):
    name = models.CharField(max_length=100, default="")
    description = models.CharField(max_length=2000, default="")
    class Meta:
        unique_together = (("name"),)
    def __unicode__(self):
        return "builder/%s" % (self.name)


class BuildBotBranch(models.Model):
    branch = models.CharField(max_length=255, null=False, default="", unique=True,)
    def __unicode__(self):
        return "(%s) %s" % (self.id, self.branch)


class BuildBotSingleBuild(models.Model):
    BUILD_STATUS_UNKNOWN  =  0
    BUILD_STATUS_FAIL     =  1
    BUILD_STATUS_SUCCESS  = 10
    BUILD_STATUS_CHOICES = (
            (BUILD_STATUS_UNKNOWN,   'unknown'),
            (BUILD_STATUS_SUCCESS,   'success'),
            (BUILD_STATUS_FAIL,      'fail'),
            )
    builder = models.ForeignKey( BuildBotBuilder )
    branch = models.ForeignKey( BuildBotBranch, default=-1 )
    rev = models.IntegerField()
    buildnumber = models.IntegerField(null=True)
    logtime = models.DateTimeField()
    status = models.IntegerField(choices=BUILD_STATUS_CHOICES)
    status_text = models.CharField(max_length=100, default="")

    def save(self, *args, **kwargs):
        self.logtime = datetime.now()
        super(BuildBotSingleBuild, self).save(*args, **kwargs)
    def __unicode__(self):
        return "%s - %s - %s - %s" % (self.builder, self.rev, self.status_nickname(), self.status_text)
    def status_nickname(self):
        return self.get_status_display()
    def status_short_nickname(self):
        n = self.get_status_display()
        if n == 'success':
            return 'ok'
        elif n == 'fail':
            return 'FAIL'
        else:
            return 'n/a'


