# -* encoding: utf-8 -*-
from django.http import HttpResponse
from django.shortcuts import render_to_response
from django.template import RequestContext
import json
from django.db.models import Q
from django.core.cache import cache

from django.conf import settings
from releaser.cifront.models import *
from releaser.cifront.events import BuildBotTrunkBuildFailed

import sys, re

def buildbot_status(request):
    packets_json = request.POST.get('packets')
    packets = json.loads(packets_json)
    for p in packets:
        if p['event'] != 'buildFinished':
            continue
        #sys.stderr.write("packet:\n%s\n\n" % (json.dumps(p, sort_keys=True, indent=2)))
        build_dict = {
                 'text': ' '.join(p['payload']['build']['text']),
                 'builderName': p['payload']['build']['builderName']
                 }
        for prop in p['payload']['build']['properties']:
            if prop[0] in ['got_revision', 'revision', 'repository', 'buildnumber', 'branch']:
                build_dict[prop[0]] = prop[1]
        if not 'branch' in build_dict or build_dict['branch'] is None:
            build_dict['branch'] = 'trunk'
        #sys.stderr.write("build:\n%s\nRELEASER_SVN: %s\n\n" % (build_dict, settings.RELEASER_SVN))
        #if build_dict['repository'] != settings.RELEASER_SVN:
        #    continue
        builder, _ = BuildBotBuilder.objects.get_or_create(name = build_dict['builderName'])
        buildbot_branch, _ = BuildBotBranch.objects.get_or_create(branch = build_dict['branch'])
        build_dict['status'] = BuildBotSingleBuild.BUILD_STATUS_UNKNOWN
        if build_dict['text'] == 'build successful':
            build_dict['status'] = BuildBotSingleBuild.BUILD_STATUS_SUCCESS
        elif re.match(r'failed', build_dict['text']):
            build_dict['status'] = BuildBotSingleBuild.BUILD_STATUS_FAIL
        else:
            build_dict['status'] = BuildBotSingleBuild.BUILD_STATUS_UNKNOWN

        # пропускаем сборки с неизвестной ревизией (бывают при ручных перезапусках)
        # TODO Если понадобится принимать сборки без ревизий -- надо разбираться и исправлять.
        # еще бывает заполнено поле got_revision, если сборка от HEAD, то revision пустая, got_regision -- честная
        if build_dict['revision'] == None or not build_dict['revision']:
            continue
        build = BuildBotSingleBuild.objects.create(
                builder = builder,
                branch = buildbot_branch,
                rev = build_dict['revision'],
                status = build_dict['status'],
                status_text = build_dict['text'],
                buildnumber = build_dict['buildnumber'],
                )

        if build.branch.branch == 'trunk':
            # уведомления для транковых сборок
            if build.status == BuildBotSingleBuild.BUILD_STATUS_FAIL:
                event = BuildBotTrunkBuildFailed({'revision': build.rev, 'builder_name': build.builder.name})
                subscriptions = event.find_subscriptions()
                event.send_notifications(subscriptions)

    return HttpResponse(json.dumps("OK", sort_keys=True), mimetype="application/javascript")


def commit_status(r, rev):
    rev = int(rev)

    builds = BuildBotSingleBuild.objects.filter(rev__in=[rev]).order_by('-builder', 'buildnumber')

    vars = {
            'builds': builds,
            'rev': rev,
            }

    return render_to_response('cifront/commit_status.html', vars,
        context_instance=RequestContext(r))

