# -* encoding: utf-8 -*-

from django.conf import settings

import threading
import time
import yaml

_update_timeout = 900 # 15 минут
_apps_conf = {}
_last_update_time = 0.0
_lock = threading.Lock()


def _get_data(add_perl_direct=False):
    apps_conf = {}

    try:
        with open(settings.APPS_CONF_FILE) as fd:
            apps_conf = yaml.load(fd)['apps']
    except:
        pass

    for app in settings.APPS_EXTRA:
        if app in apps_conf:
            apps_conf[app].update(settings.APPS_EXTRA[app])
        else:
            apps_conf[app] = settings.APPS_EXTRA[app]

    for app in apps_conf.keys():
        if (app == 'direct' and not add_perl_direct) and apps_conf[app]['type'] not in settings.APP_TYPES or \
           settings.IGNORE_FEATURE in apps_conf[app].get('ignore-features', []):
            del apps_conf[app]
            continue

        if 'releases_to_check_for_deploy' not in apps_conf[app]:
            apps_conf[app]["releases_to_check_for_deploy"] = settings.DEFAULT_RELEASES_TO_CHECK

    return apps_conf

def get(add_perl_direct=False):
    global _last_update_time
    global _apps_conf
    global _update_timeout
    global _lock

    current_time = time.time()
    if current_time - _last_update_time > _update_timeout:
        with _lock:
            if current_time - _last_update_time > _update_timeout:
                _apps_conf = _get_data(add_perl_direct=add_perl_direct)
                _last_update_time = current_time

    return _apps_conf

