# -*- encoding: utf-8 -*-

from optparse import make_option
import os.path, os
import stat

from django.template import Template, Context
from django.core.management.base import BaseCommand
from django.conf import settings

from releaser.scheduler.tasks_base import task_registry, tasks_by_launch_tags, tasks_without_launch_tags

class Command(BaseCommand):
    help = "Create per-project package files"
    debug = True

    option_list = BaseCommand.option_list + (
        make_option('--dest-dir', action='store', dest='dest_dir', type='string',
            default=None, help='Debian package directory'),
        make_option('--frontend', action='store_true', dest='frontend',
            default=False, help='Generate frontend configuration files'),
        make_option('--scripts', action='store_true', dest='scripts',
            default=False, help='Generate cron tables to launch scripts'),
        make_option('--frontend-scripts', action='store_true', dest='frontend-scripts',
            default=False, help='Generate cron tables to launch scripts on frontend'),
    )

    def process_template(self, tmpl, tmpl_vars, result_file):
        full_tmpl_file = os.path.join(settings.PROJECT_PATH, tmpl)

        t = Template(open(full_tmpl_file).read())

        tmpl_vars_copy = tmpl_vars.copy()
        tmpl_vars_copy['settings'] = settings
        data = t.render(Context(tmpl_vars_copy))

        open(result_file, "w").write(data)
        os.chmod(result_file, stat.S_IREAD | stat.S_IWUSR | stat.S_IRGRP | stat.S_IROTH)

    def handle(self, **options):
        package_name = "yandex-du-releaser-%s" % settings.PROJECT

        if options['frontend']:
            self.process_template('etc/frontend/instance.conf', {}, os.path.join(options['dest_dir'], 'etc', 'lighttpd', 'conf-enabled', "releaser-%s.conf" % settings.PROJECT))

        if options['scripts']:
            tasks = []

            for task_name in sorted(tasks_without_launch_tags):
                tasks.append({ 'name': task_name, 'schedule': task_registry[task_name]['schedule'] })

            for task_launch_tag in sorted(tasks_by_launch_tags):
                tasks.append({ 'launch_tag': task_launch_tag, 'schedule': tasks_by_launch_tags[task_launch_tag]['schedule'] })

            self.process_template('etc/cron.d', { 'tasks': tasks }, os.path.join(options['dest_dir'], 'etc', 'cron.d', package_name))

        if options['frontend-scripts']:
            self.process_template('etc/cron.d', { 'tasks': [], 'run_on_frontend': True }, os.path.join(options['dest_dir'], 'etc', 'cron.d', package_name + '-scripts-front'))
