# -* encoding: utf-8 -*-

from django.http import HttpResponse
from django.template import RequestContext
from django.shortcuts import render_to_response

from releaser.yambclient.client import YambClient

def login(r):
    retpath = r.build_absolute_uri(r.REQUEST.get('next', '/'))
    return render_to_response('common/login.html', {'retpath': retpath}, context_instance=RequestContext(r));

def yamb_send(r):
    if not r.REQUEST.get('msg') or not r.REQUEST.get('to'):
        return HttpResponse("'msg' and 'to' fields are required", status=422)

    msg = u"(Табула/yamb_send)\n%s" % r.REQUEST.get('msg')
    to = r.REQUEST.get('to').strip()

    success = YambClient().send_message(to, msg)

    if not success:
        return HttpResponse("can't send message to %s" % to, status=500)

    return HttpResponse("ok", mimetype="text/plain; charset=utf-8")


