# -*- encoding: utf-8 -*-

import urllib
import urllib2
import httplib2
import base64

from django.conf import settings

"""
Простая некеширующая обертка к (безавторизационным) методам Кондукторного API.
см. также
https://wiki.yandex-team.ru/Conductor
http://c.yandex-team.ru/groups
direct-utils/yandex-lib/conductor
"""

class ConductorRestClient(object):
    API_URL = "http://c.yandex-team.ru/api"

    def __init__(self, timeout=20):
        self.__conn = httplib2.Http(disable_ssl_certificate_validation=True, timeout=timeout,)

    def groups2hosts(self, groups):
        url = self.API_URL + '/groups2hosts/' + ",".join(groups)
        resp, content = self.__conn.request(url, method='GET')
        if int(resp['status']) != 200:
            raise Exception("can't get hosts, url %s, resp %s" % (url, resp))
        hosts = [h for h in content.split("\n") if h != '']
        return hosts


