# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'Flag'
        db.create_table('flagman_flag', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(unique=True, max_length=100, db_index=True)),
            ('value', self.gf('django.db.models.fields.CharField')(max_length=500)),
            ('starttime', self.gf('django.db.models.fields.DateTimeField')()),
            ('duration', self.gf('django.db.models.fields.IntegerField')(default=1440)),
            ('default_duration', self.gf('django.db.models.fields.IntegerField')(default=1440)),
            ('description', self.gf('django.db.models.fields.CharField')(max_length=500)),
        ))
        db.send_create_signal('flagman', ['Flag'])

    def backwards(self, orm):

        # Deleting model 'Flag'
        db.delete_table('flagman_flag')

    models = {
        'flagman.flag': {
            'Meta': {'object_name': 'Flag'},
            'default_duration': ('django.db.models.fields.IntegerField', [], {'default': '1440'}),
            'description': ('django.db.models.fields.CharField', [], {'max_length': '500'}),
            'duration': ('django.db.models.fields.IntegerField', [], {'default': '1440'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '100', 'db_index': 'True'}),
            'starttime': ('django.db.models.fields.DateTimeField', [], {}),
            'value': ('django.db.models.fields.CharField', [], {'max_length': '500'})
        }
    }

    complete_apps = ['flagman']
