# -*- coding:utf-8 -*-

from django.db import models
from datetime import datetime, timedelta

# Create your models here.
class Flag(models.Model):
    name = models.CharField( max_length = 100, unique = True, db_index = True )
    online_editable = models.BooleanField(default=False)
    value = models.CharField( max_length = 500 )
    starttime = models.DateTimeField()
    duration = models.IntegerField(default=1440)
    default_duration = models.IntegerField(default=1440)
    default_value = models.CharField( max_length = 500, default = '' )
    description = models.CharField( max_length = 500 )
    def valid(self):
        if self.duration < 0:
            return True
        elif self.duration == 0:
            return False
        else:
            return datetime.now() <= self.starttime + timedelta(minutes=self.duration)
    def start(self):
        return self.starttime.strftime('%Y-%m-%d %H:%M:%S')
    def end(self):
        return (self.starttime+timedelta(minutes=self.duration)).strftime('%Y-%m-%d %H:%M:%S')
