# -* encoding: utf-8 -*-
from django.http import HttpResponse
from django.shortcuts import render_to_response
from django.template import RequestContext
from django.contrib.auth.decorators import login_required

import urllib, urllib2, re, itertools, datetime, string, random
import sys
import xml.etree.ElementTree as ET

from django.conf import settings

@login_required
def index(request):
    stash = {'history_url': 'http://qa.yandex-team.ru/aqua/history/history.xml?testRunner=cmd&filter=directsmoke-'+request.user.username+'-'}
    if request.method == 'POST':
        # запускаем тест
        url = "http://qa.yandex-team.ru/aqua/profiles/start-cmd-run.xml"
        random_token = ''.join(random.choice(string.ascii_lowercase + string.digits) for x in range(10))
        comment = 'directsmoke-%s-%s' % (request.user.username, random_token)

	if 'directmod' in request.POST:
		ft_alias = 'directmoderation'
	else:
		ft_alias = 'directsmoke'

        data = urllib.urlencode([
                ('cmdalias', ft_alias),
                ('showlink', 'true'),
                ('tree:meta:errors', 'unexpected'),
                ('tree:meta:errors', 'critical'),
                ('tree:meta:comment', comment),
                ('tree:meta:emaillist', request.POST['emails']),
                ('tree:property:ru.yandex.autotests.direct:selenium.baseURL', request.POST['url']),
                ])
        xml = urllib2.urlopen(url, data).read()
        et = ET.fromstring(xml)
        result = et.find('data/result')
        result_url = 'http://qa.yandex-team.ru/aqua/history/history.xml?'+urllib.urlencode([
                ('testRunner', 'cmd'),
                ('filter', comment)
                ])
        stash.update({
                'result': {'status': result.attrib['status'], 'message': result.attrib['message']},
                'result_url': result_url,
                'url': request.POST['url'],
                'emails': request.POST['emails'],
                })
    else:
        stash.update({
                'url': 'http://beta.direct.yandex.ru:80',
                'emails': request.user.username + '@yandex-team.ru',
                })
    return render_to_response('functests/index.html', stash, context_instance=RequestContext(request))

