# -*- encoding: utf-8 -*-
# django-admin.py process_releaseplans --settings=releaser.settings.direct --pythonpath=../

from __future__ import with_statement

import httplib2
from urllib import urlencode

from django.core.management.base import BaseCommand
from django.db import transaction, models
from django.core.files import locks
import json

from pprint import pprint as p
import tempfile, re, string, os, time, sys, urllib2, yaml
from datetime import datetime, timedelta
from optparse import make_option
from contextlib import contextmanager

#import copy

from django.db.models import Q
from django.conf import settings
from releaser.utils import locked_file

from releaser.rights.models import HasRight
from releaser.users.models import User
from releaser.flagman.models import Flag
from releaser.gap.models import Gap

class Command(BaseCommand):
    help = "Fetch data from gap.yandex-team.ru"

    @transaction.commit_on_success
    def do_all_work(self, start, ignore_past):
        conn = httplib2.Http(disable_ssl_certificate_validation=True)

        important_roles = ['developer', 'manager', 'release_manager', 'test_engineer', 'admin']
        users = [ h.user for h in HasRight.objects.filter(right__right__in=important_roles)]
        users = list(set(users))

        for user in users:
            #if user.login != "lena-san":
            #    continue

            url = "%s/gap/export/?token=dirdev&include_hidden=1&modified_from=%s&login_list=%s" % (settings.GAP_API_URL, start, user.login)
            resp, content = conn.request(url, 'GET')
            res = json.loads(content)

            #print(yaml.dump(res, default_flow_style=False))
            for item in res['gap_list']:
                # даты из текста превращаем в даты
                for param in ['created_at', 'modified_at', 'left_edge', 'right_edge']:
                    item[param] = datetime.strptime( item[param], "%Y-%m-%dT%H:%M:%S" )

                # если событие из прошлого -- игнорируем, если выставлен параметр
                if ignore_past and item['right_edge'] < datetime.now():
                    continue

                # удаленое событие удаляем
                if item['is_hidden']:
                    try:
                        Gap.objects.get(gap_id=item['id']).delete()
                    except Gap.DoesNotExist:
                        pass
                    continue

                # сохраняем событие
                gap, _ = Gap.objects.get_or_create(
                        gap_id = item['id'],
                        defaults={
                            'absentee': user,
                            }
                        )
                gap.absentee = user
                for param in ['created_at', 'modified_at', 'left_edge', 'right_edge', 'created_by_id', 'gap_type', 'description']:
                    setattr(gap, param, item[param])
                gap.save()

        return


    def handle(self, **options):
        with locked_file('fetch_gap'):
            begin_time = datetime.now().strftime('%Y-%m-%d %H:%M:%S')
            last_run = Flag.objects.get(name='fetch_gap_last_run')

            if last_run.value == '':
                delta = 90
                base = begin_time
                ignore_past = False
            else:
                delta = 5
                base = last_run.value
                ignore_past = True

            start = datetime.strptime(base, '%Y-%m-%d %H:%M:%S') - timedelta(days=delta)

            self.do_all_work(start.strftime('%Y-%m-%d'), ignore_past)

            last_run.value = begin_time
            last_run.save()
        return

