# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'Gap'
        db.create_table('gap_gap', (
            ('gap_id', self.gf('django.db.models.fields.IntegerField')(primary_key=True)),
            ('absentee', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['users.User'])),
            ('created_at', self.gf('django.db.models.fields.DateTimeField')(null=True)),
            ('modified_at', self.gf('django.db.models.fields.DateTimeField')(null=True)),
            ('created_by_id', self.gf('django.db.models.fields.IntegerField')(null=True)),
            ('gap_type', self.gf('django.db.models.fields.CharField')(max_length=60, null=True)),
            ('left_edge', self.gf('django.db.models.fields.DateTimeField')(null=True)),
            ('right_edge', self.gf('django.db.models.fields.DateTimeField')(null=True)),
            ('description', self.gf('django.db.models.fields.TextField')(max_length=32768, null=True)),
        ))
        db.send_create_signal('gap', ['Gap'])

    def backwards(self, orm):

        # Deleting model 'Gap'
        db.delete_table('gap_gap')

    models = {
        'gap.gap': {
            'Meta': {'object_name': 'Gap'},
            'absentee': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"}),
            'created_at': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'created_by_id': ('django.db.models.fields.IntegerField', [], {'null': 'True'}),
            'description': ('django.db.models.fields.TextField', [], {'max_length': '32768', 'null': 'True'}),
            'gap_id': ('django.db.models.fields.IntegerField', [], {'primary_key': 'True'}),
            'gap_type': ('django.db.models.fields.CharField', [], {'max_length': '60', 'null': 'True'}),
            'left_edge': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'modified_at': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'right_edge': ('django.db.models.fields.DateTimeField', [], {'null': 'True'})
        },
        'users.user': {
            'Meta': {'object_name': 'User'},
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'uid': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        }
    }

    complete_apps = ['gap']
