# -*- coding:utf-8 -*-

from django.db import models
from datetime import datetime, timedelta

from releaser.users.models import User

class Gap(models.Model):
    gap_id = models.IntegerField(primary_key=True)
    absentee = models.ForeignKey(User)
    created_at = models.DateTimeField(null=True)
    modified_at = models.DateTimeField(null=True)
    created_by_id = models.IntegerField(null=True)
    gap_type = models.CharField(max_length=60, null=True)
    left_edge = models.DateTimeField(null=True)
    right_edge = models.DateTimeField(null=True)
    description = models.TextField(max_length=32*1024, null=True)
    def duration_weeks(self):
        return int((self.duration().days + 3)/7)
    def duration(self):
        return self.right_edge - (self.left_edge - timedelta(days=1))
    def __unicode__(self):
        return "%s: %s - %s (%s)" % (self.absentee.login, self.left_edge, self.right_edge, self.gap_type)

