# -* encoding: utf-8 -*-

import re, string, os, time, sys, urllib2, yaml
from datetime import datetime, timedelta

from django.db.models import Q
from django.conf import settings

from releaser.users.models import User
from releaser.gap.models import Gap

def get_gaps(**O):
    gap = {}

    records = Gap.objects.filter(right_edge__gt = datetime.now(), left_edge__lt = datetime.now() + timedelta(days=28))

    for r in records:
        if not r.absentee.login in gap:
            gap[r.absentee.login] = {
                    'login': r.absentee.login,
                    'absentee': r.absentee,
                    'all_gaps': [],
                    }
        gap[r.absentee.login]['all_gaps'] += [r]

    for login in gap:
        gap[login]['all_gaps'] = sorted(gap[login]['all_gaps'], key=lambda k: k.left_edge, reverse=False)

    return gap

