# -* encoding: utf-8 -*-
from django.http import HttpResponse, Http404, HttpResponseNotFound
from django.shortcuts import render_to_response, redirect
from django.template import RequestContext
from django.contrib.auth.decorators import login_required
from django.db.models import Q
import math, sys, yaml
from datetime import datetime, timedelta
from urllib import urlencode


from django.conf import settings
from releaser.rights.tools import allowed
from releaser.gap.tools import get_gaps

@login_required
def index(r):
    vars = {}
    vars['gaps'] = sorted(get_gaps().values(), key=lambda k: k['login'], reverse=False)

    return render_to_response('gap/index.html',
            vars,
            context_instance=RequestContext(r)
            )


