# -*- encoding: utf-8 -*-
# django-admin.py process_releaseplans --settings=releaser.settings.direct --pythonpath=../

from __future__ import with_statement

from django.core.management.base import BaseCommand
from django.db import transaction, models
from django.core.files import locks

from pprint import pprint as p
import tempfile, re, string, os, time, sys, urllib2
from datetime import datetime
from optparse import make_option
from contextlib import contextmanager

import copy

from django.db.models import Q

from suds.transport.http import HttpTransport

from django.conf import settings

from releaser.versionica.models import HostGroup
from releaser.versionica.installed_versions import has_commit

from releaser.hotfixing.models import HotfixRequest

from releaser.svnlog.models import SvnDiff

@contextmanager

def locked_file(filename):
    full_filename = "%s/%s" % (settings.LOCKS_PATH, filename)
    f = open(full_filename, 'wb')
    locks.lock(f, locks.LOCK_EX|locks.LOCK_NB)
    try:
        yield
    finally:
        locks.unlock(f)
        f.close()
        os.unlink(full_filename)


class Command(BaseCommand):
    help = "Autoprocessing of hotfix requests"

    @transaction.commit_on_success
    def update_status_done(self, group_name):
        # Для каждого запроса на хотфикс со срочностью, соответствующей группе серверов
        # выехало на соответствующий сервер?
        #   + статус = done
        #   - если статус был done -- меняем на new, иначе ничего не делаем
        if settings.PROJECT != 'javadirect':
            group = HostGroup.objects.get(name=group_name)
        else:
            # в javadirect группами из Версионики не пользуемся
            # group_name используем как признак продакшена
            group = None
        if group_name == 'production':
            hotfix_requests = HotfixRequest.objects.filter(urgency__lte=HotfixRequest.URGENCY_SOMETIME)
        else:
            hotfix_requests = HotfixRequest.objects.filter(urgency__gte=HotfixRequest.URGENCY_RC)
        svndiff_table = SvnDiff.objects.all()
        for req in hotfix_requests:
            if settings.PROJECT == 'javadirect':
                if svndiff_table.filter(rev=req.commit.rev, path__path__startswith='/trunk/arcadia/direct/perl').count() == 0:
                    # коммиты не в perl пропускаем, пока не знаем, что с ними делать
                    #sys.stderr.write('{}: arcadia but not perl, skipping\n'.format(req.commit.rev))
                    continue
                else:
                    # вообще has_commit (а точнее, вызываемый им current_version) ожидает объект первым параметром, но для приложения direct в проекте javadirect обрабатывается специально случай, когда передана строка. Делается, чтобы не передавать лишних параметров для обозначения среды, на которой смотреть версию, пока это не будет сделано по-нормальному
                    has_commit_value = has_commit(group_name, req.commit.rev, app='direct')
            else:
                has_commit_value = has_commit(group, req.commit.rev)
            #sys.stderr.write('{}: checking rev {}\n'.format(group_name, req.commit.rev))
            if req.status != HotfixRequest.STATUS_DONE and has_commit_value:
                #sys.stderr.write('{}: setting status DONE on {}\n'.format(group_name, req.commit.rev))
                req.status = HotfixRequest.STATUS_DONE
            elif req.status == HotfixRequest.STATUS_DONE and not has_commit_value:
                #sys.stderr.write('{}: setting status NEW on {}\n'.format(group_name, req.commit.rev))
                req.status = HotfixRequest.STATUS_NEW
            req.save()
        return


    def handle(self, **options):
        with locked_file('hotfixing'):
            self.update_status_done('production')
            self.update_status_done('release-ts')

            return

