# -*- encoding: utf-8 -*-
# django-admin.py process_releaseplans --settings=releaser.settings.direct --pythonpath=../

from __future__ import with_statement

from django.core.management.base import BaseCommand
from django.db import transaction, models
from django.core.files import locks

from pprint import pprint as p
import tempfile, re, string, os, time, sys, urllib2
from datetime import datetime
from optparse import make_option
from contextlib import contextmanager

import copy

from django.conf import settings

from releaser.utils import locked_file
from releaser.yambclient.client import YambClient
from releaser.rights.tools import exclusive_holder

from releaser.hotfixing.models import HotfixRequest
from releaser.hotfixing.tools import current_hotfix_requests


class Command(BaseCommand):
    help = "Reminder for RE not to forget make hotfixes twice a day"

    def remind(self):
        st = current_hotfix_requests()

        yamb = YambClient()
        to = exclusive_holder('release_engineer').login
        svnlog_url = "http://%s/svnlog" % (settings.RELEASER_DNS)
        msg = u"""(Табула) Время делать хотфиксы!

### Текущие запросы
%s

svnlog: %s
""" % ( st['message'], svnlog_url )
        yamb.send_message(to, msg)

        return


    def handle(self, **options):
        with locked_file('hotfixing_reminder'):
            self.remind()

            return

