# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'HotfixRequest'
        db.create_table('hotfixing_hotfixrequest', (
            ('commit', self.gf('django.db.models.fields.related.ForeignKey')(related_name='hotfix_requests_set', primary_key=True, to=orm['svnlog.SvnLog'])),
            ('reqid', self.gf('django.db.models.fields.BigIntegerField')()),
            ('createtime', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, db_index=True, blank=True)),
            ('applicant', self.gf('django.db.models.fields.related.ForeignKey')(to=orm['users.User'])),
            ('urgency', self.gf('django.db.models.fields.IntegerField')(default=20)),
            ('status', self.gf('django.db.models.fields.IntegerField')(default=0)),
        ))
        db.send_create_signal('hotfixing', ['HotfixRequest'])

    def backwards(self, orm):

        # Deleting model 'HotfixRequest'
        db.delete_table('hotfixing_hotfixrequest')

    models = {
        'hotfixing.hotfixrequest': {
            'Meta': {'object_name': 'HotfixRequest'},
            'applicant': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['users.User']"}),
            'commit': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'hotfix_requests_set'", 'primary_key': 'True', 'to': "orm['svnlog.SvnLog']"}),
            'createtime': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'db_index': 'True', 'blank': 'True'}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {}),
            'status': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'urgency': ('django.db.models.fields.IntegerField', [], {'default': '20'})
        },
        'svnlog.svnauthor': {
            'Meta': {'object_name': 'SvnAuthor'},
            'author_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '128'})
        },
        'svnlog.svnlog': {
            'Meta': {'object_name': 'SvnLog'},
            'author': ('django.db.models.fields.related.ForeignKey', [], {'to': "orm['svnlog.SvnAuthor']"}),
            'hotfix': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'message': ('django.db.models.fields.TextField', [], {'max_length': '16384'}),
            'rev': ('django.db.models.fields.IntegerField', [], {'primary_key': 'True'}),
            'revtime': ('django.db.models.fields.DateTimeField', [], {})
        },
        'users.user': {
            'Meta': {'object_name': 'User'},
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'uid': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        }
    }

    complete_apps = ['hotfixing']
