# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'LimtestRequest'
        db.create_table(u'hotfixing_limtestrequest', (
            ('lr_id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('reqid', self.gf('django.db.models.fields.BigIntegerField')()),
            ('applicant', self.gf('django.db.models.fields.related.ForeignKey')(related_name='limtestrequest_applicant_set', to=orm['users.User'])),
            ('doer', self.gf('django.db.models.fields.related.ForeignKey')(related_name='limtestrequest_doer_set', null=True, to=orm['users.User'])),
            ('status', self.gf('django.db.models.fields.IntegerField')(default=0)),
            ('create_time', self.gf('django.db.models.fields.DateTimeField')(default=datetime.datetime.now, db_index=True, blank=True)),
            ('not_before', self.gf('django.db.models.fields.DateTimeField')(null=True)),
            ('branch', self.gf('django.db.models.fields.CharField')(max_length=50)),
            ('tracker_issue', self.gf('django.db.models.fields.CharField')(max_length=50)),
            ('unittests_report', self.gf('django.db.models.fields.TextField')()),
            ('applicant_message', self.gf('django.db.models.fields.TextField')()),
            ('doer_message', self.gf('django.db.models.fields.TextField')()),
        ))
        db.send_create_signal(u'hotfixing', ['LimtestRequest'])


    def backwards(self, orm):
        # Deleting model 'LimtestRequest'
        db.delete_table(u'hotfixing_limtestrequest')


    models = {
        u'hotfixing.hotfixrequest': {
            'Meta': {'object_name': 'HotfixRequest'},
            'applicant': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['users.User']"}),
            'commit': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'hotfix_requests_set'", 'primary_key': 'True', 'to': u"orm['svnlog.SvnLog']"}),
            'createtime': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'db_index': 'True', 'blank': 'True'}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {}),
            'status': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'urgency': ('django.db.models.fields.IntegerField', [], {'default': '20'})
        },
        u'hotfixing.limtestrequest': {
            'Meta': {'object_name': 'LimtestRequest'},
            'applicant': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'limtestrequest_applicant_set'", 'to': u"orm['users.User']"}),
            'applicant_message': ('django.db.models.fields.TextField', [], {}),
            'branch': ('django.db.models.fields.CharField', [], {'max_length': '50'}),
            'create_time': ('django.db.models.fields.DateTimeField', [], {'default': 'datetime.datetime.now', 'db_index': 'True', 'blank': 'True'}),
            'doer': ('django.db.models.fields.related.ForeignKey', [], {'related_name': "'limtestrequest_doer_set'", 'null': 'True', 'to': u"orm['users.User']"}),
            'doer_message': ('django.db.models.fields.TextField', [], {}),
            'lr_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'not_before': ('django.db.models.fields.DateTimeField', [], {'null': 'True'}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {}),
            'status': ('django.db.models.fields.IntegerField', [], {'default': '0'}),
            'tracker_issue': ('django.db.models.fields.CharField', [], {'max_length': '50'}),
            'unittests_report': ('django.db.models.fields.TextField', [], {})
        },
        u'svnlog.svnauthor': {
            'Meta': {'object_name': 'SvnAuthor'},
            'author_id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '128'})
        },
        u'svnlog.svnlog': {
            'Meta': {'object_name': 'SvnLog'},
            'author': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['svnlog.SvnAuthor']"}),
            'hotfix': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'message': ('django.db.models.fields.TextField', [], {'max_length': '16384'}),
            'rev': ('django.db.models.fields.IntegerField', [], {'primary_key': 'True'}),
            'revtime': ('django.db.models.fields.DateTimeField', [], {})
        },
        u'users.user': {
            'Meta': {'object_name': 'User'},
            'login': ('django.db.models.fields.CharField', [], {'unique': 'True', 'max_length': '20'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '100'}),
            'uid': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'})
        }
    }

    complete_apps = ['hotfixing']