from django.db import models

from django.db import models
from datetime import datetime
from releaser.users.models import *
from releaser.svnlog.models import *

class HotfixRequest(models.Model):
    URGENCY_RIGHT_NOW = 0
    URGENCY_TODAY = 10
    URGENCY_SOMETIME = 20
    URGENCY_RC = 30
    URGENCY_CHOICES = (
            (URGENCY_RIGHT_NOW, 'right now'),
            (URGENCY_TODAY, 'today'),
            (URGENCY_SOMETIME, 'sometime'),
            (URGENCY_RC, 'RC'),
            )

    STATUS_NEW = 0
    STATUS_DECLINED = 2
    STATUS_ACCEPTED = 5
    STATUS_DONE = 10
    STATUS_CHOICES = (
            (STATUS_NEW, 'new'),
            (STATUS_DONE, 'done'),
            (STATUS_DECLINED, 'declined'),
            (STATUS_ACCEPTED, 'accepted'),
            )

    commit = models.ForeignKey(SvnLog, primary_key=True, related_name='hotfix_requests_set')
    reqid = models.BigIntegerField()
    createtime = models.DateTimeField(default=datetime.now, blank=True, db_index=True)
    applicant = models.ForeignKey(User)
    urgency = models.IntegerField(choices=URGENCY_CHOICES, default=URGENCY_SOMETIME)
    status = models.IntegerField(choices=STATUS_CHOICES, default=STATUS_NEW)

    def urgency_nicename(self):
        return self.get_urgency_display()

    def status_nicename(self):
        return self.get_status_display()

    def newness_str(self):
        d = datetime.now() - self.createtime
        if d.days < 1:
            return "%sh" % int(d.seconds / 3600)
        else:
            return "%sd" % d.days


class LimtestRequest(models.Model):
    STATUS_NEW = 0
    STATUS_DECLINED = 2
    STATUS_ACCEPTED = 5
    STATUS_DONE = 10
    STATUS_CHOICES = (
            (STATUS_NEW, 'new'),
            (STATUS_DONE, 'done'),
            (STATUS_DECLINED, 'declined'),
            (STATUS_ACCEPTED, 'accepted'),
            )
    lr_id = models.AutoField(primary_key=True,)
    reqid = models.BigIntegerField()
    applicant = models.ForeignKey(User, related_name='limtestrequest_applicant_set')
    doer = models.ForeignKey(User, null=True, related_name='limtestrequest_doer_set')
    status = models.IntegerField(choices=STATUS_CHOICES, default=STATUS_NEW)
    create_time = models.DateTimeField(default=datetime.now, blank=True, db_index=True)
    not_before = models.DateTimeField(null=True)
    branch = models.CharField( max_length = 50, )
    tracker_issue = models.CharField( max_length = 50, )
    unittests_report = models.TextField()
    applicant_message = models.TextField()
    doer_message = models.TextField()

    def __unicode__(self):
        return "%s/%s" % (self.branch, self.tracker_issue,)


