# -*- coding:utf-8 -*-

from django.conf import settings

from datetime import datetime
import re

from releaser.flagman.models import Flag
from releaser.hotfixing.events import LimtestDeployedEvent
from releaser.hotfixing.models import LimtestRequest
from releaser.scheduler.tasks_base import task
from releaser.subscriptions.models import Subscription
from releaser.versionica.models import HostProperty

@task(schedule='*/5 * * * *', launch_tag='5min')
def watch_limtest_deployed():
    properties = HostProperty.objects.all().select_related('host').filter(
        host__name__startswith='limtest',
        group__name='packages',
        property__name=settings.MAIN_DEB_PACKAGE,
        )

    # [ 'my-cool-branch' => [ { 'hostname': 'limtest1-direct.yandex.ru', 'version': '1.XXXX.YYYY~my-cool-branch-1' }, ... ], ... ]
    branches_deployed_on_hosts = {}
    for prop in properties:
        version = prop.value
        match = re.match(r'^1\.\d+(?:\.\d+)?~(.*)-1$', version)
        if match:
            branch = match.groups()[0]
            if branch not in branches_deployed_on_hosts:
                branches_deployed_on_hosts[branch] = []

            branches_deployed_on_hosts[branch].append({ 'hostname': prop.host.name, 'version': version })

    subscriptions = Subscription.objects.filter(event_type='limtest_deployed')
    lr_ids = set([ int(sub.params) for sub in subscriptions ])

    lr_id_to_limrequest_map = { lr.lr_id: lr for lr in LimtestRequest.objects.filter(lr_id__in=lr_ids) }

    for sub in subscriptions:
        lr = lr_id_to_limrequest_map[int(sub.params)]
        branch = lr.branch.replace('_', '-')

        if branch in branches_deployed_on_hosts:
            for deploy_rec in branches_deployed_on_hosts[branch]:
                event_data = {
                    'request': lr,
                    'hostname': deploy_rec['hostname'],
                    'package_version': deploy_rec['version'],
                    }
                event = LimtestDeployedEvent(event_data)
                event.send_notifications([sub])

