# -* encoding: utf-8 -*-

import math
import sys
from datetime import datetime, timedelta, date
from time import time
import re

from django.conf import settings

from releaser.users.models import User

from releaser.hotfixing.models import HotfixRequest


def current_hotfix_requests():
    if settings.PROJECT == 'direct':
        delimiter = ' ' # для того чтобы удобнее было копипастить в direct-release
    else:
        delimiter = ','
    new_hotfixes = [str(req.commit.rev) for req in HotfixRequest.objects.all().filter(status=HotfixRequest.STATUS_NEW, urgency__lte=HotfixRequest.URGENCY_SOMETIME)]
    new_hotfixes = sorted(new_hotfixes)
    new_str = delimiter.join(new_hotfixes) if len(new_hotfixes) > 0 else '-'

    accepted_hotfixes = [str(req.commit.rev) for req in HotfixRequest.objects.all().filter(status=HotfixRequest.STATUS_ACCEPTED, urgency__lte=HotfixRequest.URGENCY_SOMETIME)]
    accepted_hotfixes = sorted(accepted_hotfixes)
    accepted_str = delimiter.join(accepted_hotfixes) if len(accepted_hotfixes) > 0 else '-'

    declined_hotfixes = [str(req.commit.rev) for req in HotfixRequest.objects.all().filter(status=HotfixRequest.STATUS_DECLINED, urgency__lte=HotfixRequest.URGENCY_SOMETIME)]
    declined_hotfixes = sorted(declined_hotfixes)
    declined_str = delimiter.join(declined_hotfixes) if len(declined_hotfixes) > 0 else '-'

    msg = u"""Подтвержденные хотфиксы: %s
Неподтвержденные хотфиксы: %s
Отклоненные хотфиксы: %s
""" % (
    accepted_str,
    new_str,
    declined_str,
    )

    return {
            'new_hotfixes': new_hotfixes,
            'new_str': new_str,
            'accepted_hotfixes': accepted_hotfixes,
            'accepted_str': accepted_str,
            'declined_hotfixes': declined_hotfixes,
            'declined_str': declined_str,
            'message': msg,
            }


