# -* encoding: utf-8 -*-

from django.http import HttpResponse, Http404
from django.shortcuts import render_to_response
from django.template import RequestContext
from django.contrib.auth.decorators import login_required
from django.db.models import Q
from django.shortcuts import redirect
import math
import sys
#import datetime
from datetime import datetime, timedelta, date
from time import time
import re

from django.conf import settings

from releaser.yambclient.client import YambClient
from releaser.utils import generate_reqid
from releaser.rights.tools import allowed, has_right, exclusive_holder
from releaser.users.models import User
from releaser.svnlog.models import SvnLog
from releaser.ptera.notifications import request_notification
from releaser.subscriptions.models import Subscription

from releaser.svnlog.models import SvnDiff
from releaser.hotfixing.events import LimtestRequestEvent
from releaser.hotfixing.models import HotfixRequest, LimtestRequest
from releaser.hotfixing.tools import current_hotfix_requests
from releaser.versionica.models import GroupIncludesHost, PropertyGroup, HostProperty, HostGroup
from releaser.startrek.tools import startrek_status_key_to_str, get_startrek_robot_token
from startrek_client import Startrek

@login_required
def index(r):
    hrs = [str(hr.commit.rev) for hr in HotfixRequest.objects.all()]
    text = "\n".join(hrs)
    return HttpResponse(text, mimetype="text/plain; charset=utf-8")

@login_required
@allowed(['developer', 'manager', 'test_engineer'])
def request(r):
    revisions = r.REQUEST.getlist('rev')
    urgency_param = r.REQUEST.get('urgency', '')
    reqid = generate_reqid()

    if urgency_param == 'right_now':
        urgency = HotfixRequest.URGENCY_RIGHT_NOW
    elif urgency_param == 'today':
        urgency = HotfixRequest.URGENCY_TODAY
    elif urgency_param == 'somitime':
        urgency = HotfixRequest.URGENCY_SOMETIME
    elif urgency_param == 'rc':
        urgency = HotfixRequest.URGENCY_RC
    else:
        urgency = HotfixRequest.URGENCY_SOMETIME

    if urgency_param != 'rc':
        try:
            request_notification(
                    commits=revisions,
                    dest='production',
                    recipient=r.user.username
                    )
        except Exception, e:
            pass
    if urgency_param == 'rc':
        try:
            request_notification(
                    commits=revisions,
                    dest='ts',
                    recipient=r.user.username
                    )
        except Exception, e:
            pass

    for rev in revisions:
        applicant, _ = User.objects.get_or_create(login=r.user.username)
        try:
            req = HotfixRequest.objects.get(pk=rev)
        except HotfixRequest.DoesNotExist:
            req = HotfixRequest.objects.create(
                    commit=SvnLog.objects.get(rev=rev),
                    applicant=applicant,
                    urgency=urgency,
                    reqid=reqid,
                    )
        if req.urgency > urgency:
            req.urgency = urgency
            req.status = HotfixRequest.STATUS_NEW
            req.applicant = applicant
            req.reqid = reqid
            req.save()

        if req.status == HotfixRequest.STATUS_NEW and has_right(r.user.username, 'hotfix_accepter'):
            req.status = HotfixRequest.STATUS_ACCEPTED
            req.save()

    if urgency_param == 'right_now':
        st = current_hotfix_requests()
        yamb = YambClient()
        to = exclusive_holder('release_engineer').login
        svnlog_url = "http://%s/svnlog" % (settings.RELEASER_DNS)
        confirm_url = "http://%s/hotfixing/roger?to=%s" % (settings.RELEASER_DNS, r.user.username)
        msg = u"""(Табула / %s) запрос от %s на срочные хотфиксы %s

### Прочие запросы
%s

svnlog: %s

"вас понял": %s
""" % (
        settings.NAME,
        r.user.username,
        ",".join(revisions),
        st['message'],
        svnlog_url,
        confirm_url,
        )
        yamb.send_message(to, msg)

    if urgency_param == 'rc':
        yamb = YambClient()
        to = exclusive_holder('release_qa').login
        svnlog_url = "http://%s/svnlog" % (settings.RELEASER_DNS)
        msg = u"""(Табула / %s) запрос на хотфиксы на ТС: %s

svnlog: %s
""" % (
        settings.NAME,
        ",".join(revisions),
        svnlog_url,
        )
        yamb.send_message(to, msg)

    path = r.REQUEST.get('retpath', '/svnlog');
    return redirect(path)


@login_required
@allowed(['hotfix_accepter'])
def accept(r):
    revisions = r.REQUEST.getlist('rev')

    HotfixRequest.objects.filter(commit__in=revisions, status=HotfixRequest.STATUS_NEW).update(status=HotfixRequest.STATUS_ACCEPTED)

    path = r.REQUEST.get('retpath', '/svnlog');
    return redirect(path)


@login_required
@allowed(['hotfix_accepter'])
def decline(r):
    revisions = r.REQUEST.getlist('rev')

    requests = HotfixRequest.objects.filter(commit__in=revisions, status=HotfixRequest.STATUS_NEW)

    declined_commits = {}
    for req in requests:
        sys.stderr.write("\n\n\n%s\n\n\n\n" % (req))
        if not req.applicant.login in declined_commits:
            declined_commits[req.applicant.login] = [ req.commit.rev ]
        else:
            declined_commits[req.applicant.login] += [ req.commit.rev ]

    requests.update(status=HotfixRequest.STATUS_DECLINED)

    yamb = YambClient()
    for login in declined_commits:
        to = login
        msg = u"Табула: ОТКЛОНЕН запрос на хотфиксы %s" % (
            ", ".join([str(rev) for rev in declined_commits[login]]),
        )
        yamb.send_message(to, msg)

    path = r.REQUEST.get('retpath', '/svnlog');
    return redirect(path)


@login_required
@allowed(['release_engineer'])
def roger(r):
    to_login = r.REQUEST.get('to', '').strip()

    yamb = YambClient()
    to = to_login
    #msg = u"""(Табула) %s говорит: запрос на срочный хотфикс получен, занимаюсь
#Переписка с %s: https://mail.yandex-team.ru/webchat2/1.9.6-33/dialog.ru.html#%s@yandex-team.ru""" % ( r.user.username, r.user.username, r.user.username )
    msg = u"""(Табула) %s говорит: запрос на срочный хотфикс получен, занимаюсь
""" % ( r.user.username )
    yamb.send_message(to, msg)

    return HttpResponse("сообщение отправлено", mimetype="text/plain; charset=utf-8")

@login_required
@allowed(['release_engineer'])
def delete(r):
    revisions = r.REQUEST.getlist('rev')

    requests = HotfixRequest.objects.filter(commit__in=revisions).filter(~Q(status=HotfixRequest.STATUS_DONE))

    for req in requests:
        req.delete()

    path = r.REQUEST.get('retpath', '/svnlog');
    return redirect(path)


@login_required
def hotfixes(r):
    st = current_hotfix_requests()
    return render_to_response('hotfixing/hotfixes.html',
            {
                'hotfixes_text': st['message'],
                'project_name': settings.NAME,
                'current_time': datetime.now().strftime('%Y-%m-%d %H:%M:%S'),
            },
            context_instance=RequestContext(r)
            )


@login_required
@allowed(['developer'])
def limtest_request_process(r):
    doer_message = r.REQUEST.get('doer_message', '').strip()
    status = int(r.REQUEST.get('status', ''))
    lr_id = int(r.REQUEST.get('lr_id', ''))

    doer, _ = User.objects.get_or_create(login=r.user.username)

    req = LimtestRequest.objects.get(lr_id = lr_id)
    req.status = status
    req.doer = doer
    req.doer_message = doer_message
    req.save()

    path = r.REQUEST.get('retpath', '/hotfixing/limrequestlist');
    return redirect(path)


@login_required
@allowed(['developer', 'manager', 'test_engineer'])
def limtest_requests_list(r):
    lr = LimtestRequest.objects.all().filter(create_time__gt=datetime.now() - timedelta(days=15)).order_by('-create_time')
    return render_to_response('hotfixing/limtests_requests.html',
            {
                'limtest_requests': lr,
                'project_name': settings.NAME,
                'current_time': datetime.now().strftime('%Y-%m-%d %H:%M:%S'),
            },
            context_instance=RequestContext(r)
            )


@login_required
@allowed(['developer', 'manager'])
def limtest_form(r):
    return render_to_response('hotfixing/limtest_form.html',
            {
            },
            context_instance=RequestContext(r)
            )

@login_required
@allowed(['developer', 'manager'])
def limtest_request(r):
    branch = r.REQUEST.get('branch', '').strip()
    issue = r.REQUEST.get('issue', '').strip()
    unittests = r.REQUEST.get('unittests', '').strip()
    comments = r.REQUEST.get('comments', '').strip()
    current_time = r.REQUEST.get('current_time', 0)


    errors = []
    ok = True

    branch_path = "/branches/%s" % branch
    branch_created = SvnDiff.objects.filter(path__path=branch_path, action='A')
    branch_deleted = SvnDiff.objects.filter(path__path=branch_path, action='D')

    if len(branch_created) == 0:
        errors += [u'бранч не был создан (%s)' % branch]
        ok = False

    if len(branch_created) > 0 and len(branch_created) <= len(branch_deleted):
        errors += [u'бранч уже удален (%s)' % branch]
        ok = False

    issue_status = ''
    m = re.search(settings.ISSUE_KEY_REGEXP, issue)
    if m:
        issue = m.group(0)
        try:
            startrek = Startrek(token=get_startrek_robot_token(), useragent=settings.USER_AGENT)
            issue_obj = startrek.issues[issue]
            issue_status = startrek_status_key_to_str(issue_obj.status.key)
        except Exception, e:
            errors += ["Проблемы с трекером (%s)" % (str(e))]
            ok = False
    else:
        errors += [u'неправильный тикет (%s)' % issue]
        ok = False

    # ключ статуса 'testing' в Стартреке соответствует статусам из Джиры 'Testing' релиза и 'In Testing' "обычного" тикета, так что статус 'Testing' вставлен костылём
    # TODO избавиться из статусов Джиры вообще
    if issue_status != '' and not issue_status in ['Beta-tested', 'Tested', 'Resolved', 'In Testing', 'Testing', 'Ready for test']:
        errors += [u'неправильный статус тикета (%s)' % issue_status]
        ok = False

    if not re.search(r'PASS', unittests):
        errors += [u'не прошли юнит-тесты']
        ok = False

    if not ok:
        template = 'hotfixing/limrequest_fail.html'
        return render_to_response(template,
                {
                    'current_url': r.build_absolute_uri('/'),
                    'errors': errors,
                    },
                context_instance=RequestContext(r)
                )

    applicant, _ = User.objects.get_or_create(login=r.user.username)
    req = LimtestRequest.objects.create(
            reqid = r.reqid,
            applicant = applicant,
            status = LimtestRequest.STATUS_NEW,
            branch = branch,
            tracker_issue = issue,
            unittests_report = unittests,
            applicant_message = comments,
            )

    # подписки на уведомления о выкладке
    # кто создал запрос, того уведомляем в yamb
    Subscription.objects.create(
        owner=applicant,
        event_type='limtest_deployed',
        params=req.lr_id,
        notification_type=Subscription.NOTIFICATION_TYPE_YAMB,
        recipient=applicant.login,
        notify_once=True,
        )

    # и ещё пишем комментарий в тикет
    Subscription.objects.create(
        owner=applicant,
        event_type='limtest_deployed',
        params=req.lr_id,
        notification_type=Subscription.NOTIFICATION_TYPE_STARTREK,
        recipient=issue,
        notify_once=True,
        )

    event_data = {
        'request': req,
        'issue_status': issue_status,
        'versionica_url': r.build_absolute_uri('/versionica?host_group=production'),
        }
    event = LimtestRequestEvent(event_data)
    subscriptions = event.find_subscriptions()
    event.send_notifications(subscriptions)

    recipients = [ { 'recipient': sub.recipient, 'notification_type': sub.get_notification_type_display() } for sub in subscriptions ]

    template = 'hotfixing/limrequest_ok.html'

    return render_to_response(template,
            {
                'current_url': r.build_absolute_uri('/'),
                'message': event.message_text(),
                'recipients': recipients,
            },
            context_instance=RequestContext(r)
            )
