# -* encoding: utf-8 -*-
from django.http import HttpResponse, Http404, HttpResponseNotFound
from django.shortcuts import render_to_response
from django.template import RequestContext
from django.contrib.auth.decorators import login_required
from django.core.urlresolvers import reverse
from django.db.models import Q
import sys
from math import log

from django.conf import settings

from releaser.utils import calc_font_size
from releaser.svnlog.models import *
from releaser.releaseplanning.tasks import get_recent_tasks, tasks_waiting_for_release
from releaser.rights.models import HasRight
from releaser.svnlog.tools import get_svnlog_stat
from releaser.versionica.models import HostGroup
from releaser.metatracker import views as MetatrackerViews

def index_united(r):
    return render_to_response('index/index_united.html', {
        },
        context_instance=RequestContext(r))

def index(r):
    if settings.TABULA_UNITED:
        return index_united(r)

    # Полный список приложений, по строкам
    full_app_menu = (
            (
                {
                    'href': '/svnlog',
                    'logo': 'tabula_svnlog.png',
                    'title': 'SvnLog',
                    'comment': 'История коммитов и краткие покоммитные ревью',
                    'condition': True,
                    },
                {
                    'href': '/releaseplanning',
                    'logo': 'tabula_hall_of_fame.png',
                    'title': 'Hall of Fame',
                    'comment': 'Дайджест разработки, планы на будущие релизы',
                    'condition': settings.RELEASEPLANNING_ENABLED,
                    },
                {
                    'href': reverse(MetatrackerViews.index),
                    'logo': 'tabula_metatracker.png',
                    'title': 'Метатрекер',
                    'comment': "Проблемы в релизах\
                    <br>\
                    <a href='%s'>Таймлайн релизный</a>\
                    <br>\
                    <a href='%s'>Таймлайн общий</a>" % (
                        reverse(MetatrackerViews.releaseTimeline),
                        reverse(MetatrackerViews.timelineByST),
                    ),
                    'condition': settings.METATRACKER_ENABLED,
                    },
                ),
            (
                {
                    'href': '/versionica/property?group=packages',
                    'logo': 'tabula_versionica.png',
                    'title': 'Версионика',
                    'comment': "<a href='/versionica/property?group=packages'>Версии пакетов сейчас</a> / <a href='/versionica/propertylog?group=packages'>лог</a>\
                    <br>\
                    <br>\
                    <a href='/versionica/property?group=db'>Настройки БД сейчас</a> / <a href='/versionica/propertylog?group=db'>лог</a>",
                    'condition': settings.VERSIONICA_ENABLED,
                    },
                {
                    'href': '/autobeta',
                    'logo': 'tabula_autobeta.png',
                    'title': 'Автобеты',
                    'comment': "Чистые автообновляемые беты",
                    'condition': settings.AUTOBETA_ENABLED,
                    },
                {
                    'href': '/flagman/bookmarks',
                    'logo': 'tabula_bookmarks.png',
                    'title': 'Полезные ссылки',
                    'comment': '',
                    'condition': settings.BOOKMARKS_ENABLED,
                    },
                ),
            (
                {
                    'href': '/m',
                    'logo': 'tabula_graph.png',
                    'title': 'Графики',
                    'comment': 'Кардиограмма сервиса',
                    'condition': True,
                    },
                {
                    'href': '/t',
                    'logo': 'tabula_timer.png',
                    'title': 'Таймер',
                    'comment': 'Для планерок и совещаний: чтобы не заговариваться',
                    'condition': settings.TIMER_ENABLED,
                    },
                {
                    'href': '/db',
                    'logo': 'tabula_dbschema.png',
                    'title': 'Схема БД',
                    'comment': '"All My Circuits"',
                    'condition': settings.DBSCHEMA_ENABLED,
                    },
                ),
            (
                {
                    'href': '/testupdate',
                    'logo': 'tabula_testupdate.png',
                    'title': 'Обновление ТС',
                    'comment': "<a href='/testupdate'>test, test2, test-sand, test-load</a>\
                    <br>\
                    <a href='/cloud_testupdate'>test-cloud</a>",
                    'condition': settings.TESTUPDATE_ENABLED,
                    },
                {
                    'href': '/zkbrowser',
                    'logo': 'tabula_zkbrowser.png',
                    'title': 'ZooKeeper',
                    'comment': 'Браузер базы конфигов ZooKeeper',
                    'condition': settings.ZKBROWSER_ENABLED,
                    },
                ),
            )

    # Из полного списка отбираем приложения, доступные в текущем проекте
    app_menu = []
    for full_row in full_app_menu:
        row = []
        for item in full_row:
            if item['condition']:
                row.append(item)
        app_menu.append(row)

    task_info = get_recent_tasks()
    for week in task_info['current_weeks']:
        week['title'] = week['title_descriptive']

    RMs = [ rec.user for rec in HasRight.objects.filter(right__right='release_manager') ]
    REngs = [ rec.user for rec in HasRight.objects.filter(right__right='release_engineer') ]
    RQAs = [ rec.user for rec in HasRight.objects.filter(right__right='release_qa') ]



    return render_to_response('index/index.html', {
        'project_name': settings.NAME,
        'app_menu': app_menu,
        'current_weeks': task_info['current_weeks'],
        #'RM': RMs[0],
        'REng': REngs[0],
        'RQA': RQAs[0],
        'svnlog_stat': get_svnlog_stat(),
        },
        context_instance=RequestContext(r))

