#!/usr/bin/env python
# -*- coding: utf-8 -*-

import subprocess

class InfraClient(object):
    """
    клиент для работы с infra.yandex-team.ru
    """

    TOKEN_PATH = '/etc/direct-tokens/oauth_infra_robot-direct-infra'


    @staticmethod
    def create_event(service, environment, type, severity, title, start_time_ts, finish_time_ts=None, description="",
                     tickets=[], dcs=[]):
        """
        создать событие в инфре
        """
        cmd = [
            "/usr/local/bin/create-infra-event",
            '-s', str(service),
            '-e', str(environment),
            '-t', type,
            '-sv', severity,
            '--title', title,
            '--start-time', str(start_time_ts),
            '--token', InfraClient.TOKEN_PATH,
        ]

        if description:
            cmd += ['--description', description]

        if finish_time_ts:
            cmd += ['--finish-time', str(finish_time_ts)]

        for ticket in tickets:
            cmd += ["--ticket", ticket]

        for dc in dcs:
            cmd += ["-dc", dc]

        subprocess.check_output(cmd)

