# -*- encoding: utf-8 -*-

from suds.client import Client
from suds.transport.http import HttpTransport
import urllib2

import warnings
# пропускаем DeprecationWarning: the sha module is deprecated; use the hashlib module instead
#            DeprecationWarning: the md5 module is deprecated; use hashlib instead
with warnings.catch_warnings():
    warnings.filterwarnings("ignore", category=DeprecationWarning)
    import xmpp

from django.conf import settings

class JabberClient(object):
    def __init__(self, server=settings.JABBER_SERVER, xmpp_server=settings.JABBER_XMPP_SERVER, user=settings.JABBER_USER, password=settings.JABBER_PASS, resource=settings.JABBER_RESOURCE):
        self.server=server
        self.xmpp_server=xmpp_server
        self.user=user
        self.password=password
        self.resource=resource

        self.client = xmpp.Client(self.server, debug=[])
        # пропускаем DeprecationWarning: socket.ssl() is deprecated.  Use ssl.wrap_socket() instead.
        with warnings.catch_warnings():
            warnings.filterwarnings("ignore", category=DeprecationWarning)
            self.client.connect(server=self.xmpp_server, use_srv=False)
        self.client.auth(self.user, self.password, self.resource)
        self.client.sendInitPresence()

    def send_message(self, to, msg):
        message = xmpp.Message(to, msg)
        message.setAttr('type', 'chat')

        self.client.SendAndWaitForResponse(message, timeout=1)
        return
