# -* encoding: utf-8 -*-
import math, sys, re

from django.conf import settings
from releaser.logcmd.models import LogCmd
from releaser.utils import generate_reqid
import releaser.logcmd.tools

class LoggingMiddleware(object):
    """
    Middleware для записи в БД логов обращения к веб-интерфейсу.
    До выполнения view в объект request дописывается reqid,
    его можно использовать в прикладном коде.
    """

    def process_request(self, request):
        request.reqid = generate_reqid()
        #request.user.username = 'raketa'
        return None


    def process_response(self, request, response):
        p = releaser.logcmd.tools.parse_request_path(request.path)

        # TODO возможно, правильнее логгировать не "все, кроме...", а "все, что внесено в список"
        # не логгируем запросы статики, jira-статусов, графиков
        # (записей много, хранить неинтересно)
        if p['dir'] in ['', 'jira', 'static', 'screen', 'm']:
            return response

        # то же самое с записью пакетов в Версионику -- там ведется свой собственный лог
        if p['cmd'] in ['/versionica/update']:
            return response

        try:
            log = LogCmd(
                    reqid    = request.reqid,
                    ip       = request.META['REMOTE_ADDR'],
                    login    = request.user.username,
                    path     = p['path'][:50],
                    cmd      = p['cmd'][:50],
                    param    = request.META['QUERY_STRING'][:4096],
                    http_status = response.status_code
                    )
            log.save()
        except Exception, e:
            pass

        return response
