# encoding: utf-8
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):

        # Adding model 'LogCmd'
        db.create_table('logcmd_logcmd', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('reqid', self.gf('django.db.models.fields.BigIntegerField')(default=0)),
            ('logtime', self.gf('django.db.models.fields.DateTimeField')(db_index=True)),
            ('ip', self.gf('django.db.models.fields.CharField')(default='', max_length=16)),
            ('login', self.gf('django.db.models.fields.CharField')(default='', max_length=50)),
            ('path', self.gf('django.db.models.fields.CharField')(default='', max_length=50)),
            ('param', self.gf('django.db.models.fields.CharField')(default='', max_length=4096)),
            ('http_status', self.gf('django.db.models.fields.IntegerField')(default=-1)),
        ))
        db.send_create_signal('logcmd', ['LogCmd'])

    def backwards(self, orm):

        # Deleting model 'LogCmd'
        db.delete_table('logcmd_logcmd')

    models = {
        'logcmd.logcmd': {
            'Meta': {'object_name': 'LogCmd'},
            'http_status': ('django.db.models.fields.IntegerField', [], {'default': '-1'}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'ip': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '16'}),
            'login': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'logtime': ('django.db.models.fields.DateTimeField', [], {'db_index': 'True'}),
            'param': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '4096'}),
            'path': ('django.db.models.fields.CharField', [], {'default': "''", 'max_length': '50'}),
            'reqid': ('django.db.models.fields.BigIntegerField', [], {'default': '0'})
        }
    }

    complete_apps = ['logcmd']
